#ifndef INCLUDE_INTERNAL_FOLDER_CLEAR_CASCADE_DATA_H
#define INCLUDE_INTERNAL_FOLDER_CLEAR_CASCADE_DATA_H

#include <macs/folder_set.h>

namespace macs {
namespace pg {

class ClearCascadeData {
public:
    using FoldersList = std::vector<Folder>;
    ClearCascadeData(const FolderSet &fs, const std::string& rootFid) {
        const auto rootFolder = fs.at(rootFid);
        parentFid_ = rootFolder.parentId();
        trashFid_ = fs.fid(Folder::Symbol::trash);
        fillFoldersToClear(fs, rootFolder);
    }

    const FoldersList& foldersToMove() const {
        return foldersToMove_;
    }
    const FoldersList& foldersToDelete() const {
        return foldersToDelete_;
    }

    const std::string & parentFid() const {
        return parentFid_;
    }

    const std::string & trashFid() const {
        return trashFid_;
    }

    std::string getNameForMove(const Folder& folder) const {
        return getFolderDisplayName(folder.name());;
    }

private:
    std::string parentFid_;
    std::string trashFid_;

    FoldersList foldersToMove_;
    FoldersList foldersToDelete_;

    void fillFoldersToClear(const FolderSet &fs, const Folder& rootFolder) {
        for (const auto &it : fs) {
            if (it.second.parentId() == rootFolder.fid()) {
                fillFoldersToClear(fs, it.second);
            }
        }
        if (rootFolder.isSystem()) {
            foldersToMove_.push_back(rootFolder);
        } else {
            foldersToDelete_.push_back(rootFolder);
        }
    }
};

} //namespace pg
} //namespace macs


#endif //INCLUDE_INTERNAL_FOLDER_CLEAR_CASCADE_DATA_H
