#pragma once

#include <boost/algorithm/string.hpp>

#include <macs/folder_factory.h>
#include <pgg/numeric_cast.h>
#include <internal/folder/folder_type.h>
#include <internal/folder/symbols.h>
#include <internal/reflection/folder.h>

namespace macs {
namespace pg {

class FolderFactory: public macs::FolderFactory {
public:

    FolderFactory &typeFromPG(const FolderType & pgType) {
        auto s = symbols::defineFolderSymbol(pgType);
        symbol(s);
        type(s == Folder::Symbol::none ? Folder::Type::user : Folder::Type::system);
        return *this;
    }

    FolderFactory &seenMessages(const size_t & messageSeen) {
        newMessages(product().messagesCount() - messageSeen);
        return *this;
    }

    FolderFactory &fromReflection(const reflection::Folder& v) {
        create();

        fid(std::to_string(v.fid));
        parentId(v.parent_fid ? std::to_string(*v.parent_fid) : Folder::noParent);
        if (v.folder_path.empty()) {
            throw std::runtime_error("create folder error: empty folder_path");
        }
        name(Folder::Path{v.folder_path.back()}.name());
        typeFromPG(FolderType::fromString(v.type, std::nothrow));
        creationTime(std::to_string(v.created));
        bytes(PGG_NUMERIC_CAST(std::size_t, v.message_size));
        messages(PGG_NUMERIC_CAST(std::size_t, v.message_count));
        seenMessages(PGG_NUMERIC_CAST(std::size_t, v.message_seen));
        recentMessages(PGG_NUMERIC_CAST(std::size_t, v.message_recent));
        unvisited(v.unvisited);
        position(PGG_NUMERIC_CAST(std::size_t, v.position));

        revision(PGG_NUMERIC_CAST(Revision, v.revision));
        imapUidNext(PGG_NUMERIC_CAST(std::size_t, v.next_imap_id));
        imapUidValidity(PGG_NUMERIC_CAST(std::size_t, v.uidvalidity));
        imapFirstUnseen(PGG_NUMERIC_CAST(std::size_t, v.first_unseen));

        pop3On(v.pop3state.enabled);
        isThreadable(v.is_threadable);

        subscribedForSharedFolder(v.subscribed_for_shared_folder
                && *(v.subscribed_for_shared_folder));

        return *this;
    }

};

} // namespace macs
} // namespace pg

