#pragma once

#include <pgg/enumeration.h>

namespace macs::pg {

struct __FolderType{
    enum Enum {
        unknown,
        user,
        inbox,
        spam,
        trash,
        sent,
        outbox,
        drafts,
        archive,
        templates,
        discount,
        zombie,
        unsubscribe,
        pending,
        hidden_trash,
        restored,
        reply_later,
    };

    typedef pgg::Enum2String<Enum>::Map Map;

    void fill(Map & map) const{
#define ADD_ENUM_TO_MAP(name) map.insert(Map::value_type(name, #name))
        ADD_ENUM_TO_MAP(user);
        ADD_ENUM_TO_MAP(inbox);
        ADD_ENUM_TO_MAP(spam);
        ADD_ENUM_TO_MAP(trash);
        ADD_ENUM_TO_MAP(sent);
        ADD_ENUM_TO_MAP(outbox);
        ADD_ENUM_TO_MAP(drafts);
        ADD_ENUM_TO_MAP(archive);
        ADD_ENUM_TO_MAP(templates);
        ADD_ENUM_TO_MAP(discount);
        ADD_ENUM_TO_MAP(zombie);
        ADD_ENUM_TO_MAP(unsubscribe);
        ADD_ENUM_TO_MAP(pending);
        ADD_ENUM_TO_MAP(hidden_trash);
        ADD_ENUM_TO_MAP(restored);
        ADD_ENUM_TO_MAP(reply_later);
#undef ADD_ENUM_TO_MAP
    }

    typedef __FolderType Filler;
};

typedef pgg::Enumeration<__FolderType> FolderType;

} // namespace macs::pg
