#ifndef MACS_PG_FOLDERS_CONVERTER_H_004227012016
#define MACS_PG_FOLDERS_CONVERTER_H_004227012016

#include <boost/range/algorithm/transform.hpp>

#include <macs_pg/logging.h>
#include <internal/folder/factory.h>
#include <macs/folder_set.h>

#include <pgg/cast.h>

namespace macs {
namespace pg {

FolderSet normalize(std::vector<Folder> fs, logging::v2::LogPtr log, const std::string& details);

template <typename DataRange>
FolderSet convertFolders(DataRange range) {
    FoldersMap folders;
    boost::transform(range, std::inserter(folders, folders.end()),
                     [] (auto row) {
                         auto folder = FolderFactory().fromReflection(pgg::cast<reflection::Folder>(row)).product();
                         std::string fid = folder.fid();
                         return std::make_pair(std::move(fid), std::move(folder));
                     });
    return FolderSet(std::move(folders));
}

} // namespace macs
} // namespace pg

#endif /* MACS_PG_FOLDERS_CONVERTER_H_004227012016 */
