#ifndef MACS_PG_QUERY_H_164512012015
#define MACS_PG_QUERY_H_164512012015

#include <pgg/query/boundaries.h>
#include <internal/query/ids.h>
#include <macs/folder.h>
#include <internal/folder/symbols.h>
#include <boost/hana/tuple.hpp>

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::Folder::Symbol> {
    template <typename MapperT>
    void map(const MapperT & m) const {
        m.mapValue(type().toString(), "symbol");
    }
    auto get() const {
        return type().toString();
    }
    void set(const macs::Folder::Symbol & v) { v_ = v; }
    Base& symbol(const macs::Folder::Symbol & v) {
        set(v);
        return static_cast<Base&>(*this);
    }
private:
    const macs::Folder::Symbol & symbol() const {
        return v_;
    }
    macs::pg::FolderType type() const {
        return macs::pg::symbols::FolderTypeConverter().fromSymbol(symbol());
    }
    macs::Folder::Symbol v_ = macs::Folder::Symbol::none;
};

} // namespace query
} // namespace pgg

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;

struct MailboxRevision : QueryImpl<MailboxRevision, UserId> {
    using Inherited::Inherited;
};

struct AllFoldersList : QueryImpl<AllFoldersList, UserId> {
    using Inherited::Inherited;
};

struct CreateFolder : QueryImpl<CreateFolder, UserId, pgg::RequestInfo, FolderName, ParentFolderId, Folder::Symbol> {
    using Inherited::Inherited;
};

struct GetOrCreateFolder : QueryImpl<GetOrCreateFolder, UserId, pgg::RequestInfo, FolderName, ParentFolderId, Folder::Symbol> {
    using Inherited::Inherited;
};

struct DeleteFolder : QueryImpl<DeleteFolder, UserId, pgg::RequestInfo, FolderId> {
    using Inherited::Inherited;
};

struct ResetFolderUnvisited : QueryImpl<ResetFolderUnvisited, UserId, pgg::RequestInfo, FolderId> {
    using Inherited::Inherited;
};

struct MoveFolderMessages : QueryImpl<MoveFolderMessages, UserId, pgg::RequestInfo, SrcFolderId, DstFolderId> {
    using Inherited::Inherited;
};

struct UpdateFolder : QueryImpl<UpdateFolder, UserId, pgg::RequestInfo, FolderId, FolderName, ParentFolderId> {
    using Inherited::Inherited;
};

struct UpdateFolderSymbol : QueryImpl<UpdateFolderSymbol, UserId, pgg::RequestInfo, FolderId, macs::Folder::Symbol> {
    using Inherited::Inherited;
};

struct SetFolderPosition : QueryImpl<SetFolderPosition, UserId, FolderId, Position> {
    using Inherited::Inherited;
};

struct SetPop3 : QueryImpl<SetPop3, UserId, pgg::RequestInfo, FolderIdListOn, FolderIdListOff> {
    using Inherited::Inherited;
};

struct SetFolderArchivationRules : QueryImpl<SetFolderArchivationRules,
        UserId, FolderId, ArchivationType, ArchivationTtl, pgg::RequestInfo, MaxFolderSize> {
    using Inherited::Inherited;
};

struct RemoveFolderArchivationRules : QueryImpl<RemoveFolderArchivationRules,
        UserId, FolderId, pgg::RequestInfo> {
    using Inherited::Inherited;
};

} // namespace query
} // namespace macs
} // namespace pg

#endif /* MACS_PG_QUERY_H_164512012015 */
