#ifndef INCLUDE_INTERNAL_HOOKS_ON_CHECK_DUPLICATES_H_
#define INCLUDE_INTERNAL_HOOKS_ON_CHECK_DUPLICATES_H_

//#include <apq/result.hpp>
//#include <apq/row_iterator.hpp>

#include <macs/hooks.h>
#include <pgg/range.h>
#include <pgg/cast.h>
#include <pgg/numeric_cast.h>
#include <internal/reflection/find_duplicates.h>
#include <internal/envelope/from_recipients_matcher.h>

#include <boost/range/algorithm/find_if.hpp>
#include <boost/range/adaptor/transformed.hpp>

namespace macs {
namespace pg {

class OnCheckDuplicatesHandler {
public:
    OnCheckDuplicatesHandler(const std::string & hdr_from, const std::string & fid,
            CheckDuplicates hook) : from(hdr_from), fid(fid), hook(std::move(hook)) {}

    template <typename DataRange>
    void operator() (error_code res, DataRange data) const {
        if (res) {
            hook(std::move(res), macs::Mid());
            return;
        }

        FromRecipientsMatcher fromMatcher(from);
        using FD = reflection::FindDuplicates;
        auto i = boost::find_if(data | boost::adaptors::transformed(pgg::Cast< FD >()),
            [&] (const FD & v) {
                    return fid == std::to_string( v.fid ) && fromMatcher.match( v.recipients );
                });

        if( i.base() != data.end() ) {
            const auto v = *i;
            hook(error_code(), std::to_string( v.mid ));
        } else {
            hook(error_code(), macs::Mid());
        }
    }

protected:
    const std::string from;
    const string fid;
    CheckDuplicates hook;
};

} // namespace pg
} // namespace macs


#endif /* INCLUDE_INTERNAL_HOOKS_ON_CHECK_DUPLICATES_H_ */
