#ifndef MACS_PG_ENVELOPE_CONV_UID_MAPERT_H_171619092014
#define MACS_PG_ENVELOPE_CONV_UID_MAPERT_H_171619092014

#include <macs/data.h>
#include <pgg/numeric_cast.h>
#include <internal/reflection/imap_uid_map.h>
#include <internal/reflection/imap_envelope.h>
#include <internal/reflection/imap_envelope_changes.h>
#include <internal/reflection/imap_envelope_details.h>
#include <internal/reflection/imap_unsubscribed_data.h>
#include <internal/reflection/pop3_message.h>
#include <string>

namespace macs {
namespace pg {

#define MODIFIER(FACTORY,NAME,FIELD,TYPE) \
    FACTORY& NAME (TYPE NAME) { \
            _product.FIELD = NAME; \
            return *this; \
        }

//-----------------------------------------------------------------------------
// UidMapRecord

class ImapUidMapFactory
{
public:
    ImapUidMapFactory& newRecord() { _product = ImapUidMapRecord(); return *this; }

    MODIFIER( ImapUidMapFactory, uid, uid, uint32_t)
    MODIFIER( ImapUidMapFactory, chain, chain, uint32_t)

    ImapUidMapFactory& fromReflection(const reflection::ImapUidMap& v) {
        uid(PGG_NUMERIC_CAST(uint32_t, v.imap_id));
        chain(PGG_NUMERIC_CAST(uint32_t, v.chain ? *v.chain : 0));
        return *this;
    }

    const ImapUidMapRecord & product() const { return _product; }

private:
    ImapUidMapRecord _product;
};

//-----------------------------------------------------------------------------
// ImapEnvelope

class ImapEnvelopeFactory
{
public:
    ImapEnvelopeFactory& newRecord() { _product = ImapEnvelope(); return *this; }

    MODIFIER( ImapEnvelopeFactory, uid, uid, uint32_t)
    MODIFIER( ImapEnvelopeFactory, num, num, uint32_t)
    MODIFIER( ImapEnvelopeFactory, mid, mid, uint64_t)
    MODIFIER( ImapEnvelopeFactory, modseq, modseq, uint64_t)
    MODIFIER( ImapEnvelopeFactory, labels, labels, const std::vector<std::string>&)
    MODIFIER( ImapEnvelopeFactory, receivedDate, receivedDate, std::time_t)

    void setSeen(bool v)    { if (v) _product.labels.push_back("FAKE_SEEN_LBL"); }
    void setRecent(bool v)  { if (v) _product.labels.push_back("FAKE_RECENT_LBL"); }
    void setDeleted(bool v) { if (v) _product.labels.push_back("FAKE_DELETED_LBL"); }

    void addLabel(int lid) {
        _product.labels.emplace_back(std::to_string(lid));
    }

    ImapEnvelopeFactory& fromReflection(const reflection::ImapEnvelope& v) {
        uid(PGG_NUMERIC_CAST(uint32_t, v.imap_id));
        mid(PGG_NUMERIC_CAST(uint64_t, v.mid));
        modseq(PGG_NUMERIC_CAST(uint64_t, v.revision));
        receivedDate(v.received_date);
        for (int lid : v.lids) {
            addLabel(lid);
        }
        setSeen(v.seen);
        setRecent(v.recent);
        setDeleted(v.deleted);
        return *this;
    }

    const ImapEnvelope& product() const { return _product; }

private:
    ImapEnvelope _product;
};

//-----------------------------------------------------------------------------
// ImapEnvelopeChanges

class ImapEnvelopeChangesFactory
{
public:
    ImapEnvelopeChangesFactory& newRecord() { _product = ImapEnvelopeChanges(); return *this; }

    MODIFIER( ImapEnvelopeChangesFactory, uid, envelope.uid, uint32_t)
    MODIFIER( ImapEnvelopeChangesFactory, mid, envelope.mid, uint64_t)
    MODIFIER( ImapEnvelopeChangesFactory, modseq, envelope.modseq, uint32_t)
    MODIFIER( ImapEnvelopeChangesFactory, receivedDate, envelope.receivedDate, std::time_t)
    MODIFIER( ImapEnvelopeChangesFactory, baseId, baseId, uint32_t)
    MODIFIER( ImapEnvelopeChangesFactory, offset, offset, uint32_t)
    MODIFIER( ImapEnvelopeChangesFactory, deleted, deleted, bool)
    MODIFIER( ImapEnvelopeChangesFactory, labels, envelope.labels, const std::vector<std::string>&)

    void setSeen(bool v)    { if (v) _product.envelope.labels.push_back("FAKE_SEEN_LBL"); }
    void setRecent(bool v)  { if (v) _product.envelope.labels.push_back("FAKE_RECENT_LBL"); }
    void setDeleted(bool v) { if (v) _product.envelope.labels.push_back("FAKE_DELETED_LBL"); }

    void addLabel(int lid) {
        _product.envelope.labels.emplace_back(std::to_string(lid));
    }

    ImapEnvelopeChangesFactory& fromReflection(const reflection::ImapEnvelopeChanges& v) {
        uid(PGG_NUMERIC_CAST(uint32_t, v.imap_id));
        mid(PGG_NUMERIC_CAST(uint64_t, v.mid));
        modseq(PGG_NUMERIC_CAST(uint32_t, v.revision));
        baseId(PGG_NUMERIC_CAST(uint32_t, v.chained_id));
        offset(PGG_NUMERIC_CAST(uint32_t, v.distance));
        receivedDate(v.received_date);
        for (int lid : v.lids) {
            addLabel(lid);
        }
        setSeen(v.seen);
        setRecent(v.recent);
        setDeleted(v.deleted);
        deleted(v.removed);
        return *this;
    }

    const ImapEnvelopeChanges& product() const { return _product; }

private:
    ImapEnvelopeChanges _product;
};

//-----------------------------------------------------------------------------
// ImapEnvelopeDetails

class ImapEnvelopeDetailsFactory
{
public:
    ImapEnvelopeDetailsFactory& newRecord() { _product = ImapEnvelopeDetails(); return *this; }

    MODIFIER( ImapEnvelopeDetailsFactory, mid, envelope.mid, uint64_t)
    MODIFIER( ImapEnvelopeDetailsFactory, smid, mid, std::string)
    MODIFIER( ImapEnvelopeDetailsFactory, stid, stid, std::string)
    MODIFIER( ImapEnvelopeDetailsFactory, size, size, uint64_t)

    ImapEnvelopeDetailsFactory& fromReflection(const reflection::ImapEnvelopeDetails& v) {
        mid(PGG_NUMERIC_CAST(uint64_t, v.mid));
        smid(std::to_string(v.mid));
        stid(v.st_id);
        size(PGG_NUMERIC_CAST(uint64_t, v.size));
        return *this;
    }

    const ImapEnvelopeDetails& product() const { return _product; }

private:
    ImapEnvelopeDetails _product;
};

//-----------------------------------------------------------------------------
// ImapEnvelopeByMessageID

class ImapEnvelopeByMessageIDFactory
{
public:
    ImapEnvelopeByMessageIDFactory& newRecord() { _product = ImapEnvelopeDetails(); return *this; }

    ImapEnvelopeByMessageIDFactory& fromReflection(const reflection::ImapEnvelope& v) {
        _product.envelope = ImapEnvelopeFactory().fromReflection(v).product();
        _product.mid = std::to_string(v.mid);
        return *this;
    }
    const ImapEnvelopeDetails& product() const { return _product; }

private:
    ImapEnvelopeDetails _product;
};


//-----------------------------------------------------------------------------
// ImapUnsubscribedDataFactory

class ImapUnsubscribedDataFactory
{
public:
    ImapUnsubscribedDataFactory& newRecord() { _product = ImapUnsubscribedData(); return *this; }

    MODIFIER( ImapUnsubscribedDataFactory, fullName, fullName, std::vector<std::string>)
    MODIFIER( ImapUnsubscribedDataFactory, revision, revision, uint64_t)

    ImapUnsubscribedDataFactory& fromReflection(const reflection::ImapUnsubscribedData& v) {
        fullName(v.full_name);
        revision(PGG_NUMERIC_CAST(uint64_t, v.revision));
        return *this;
    }

    const ImapUnsubscribedData & product() const { return _product; }

private:
    ImapUnsubscribedData _product;
};

//-----------------------------------------------------------------------------
// Pop3MessageFactory

class Pop3MessageFactory
{
public:
    Pop3MessageFactory& newRecord() { _product = Pop3Message(); return *this; }

    MODIFIER( Pop3MessageFactory, uidl, base.uidl, const std::string&)
    MODIFIER( Pop3MessageFactory, size, base.size, uint64_t)
    MODIFIER( Pop3MessageFactory, fid, base.fid, const std::string&)
    MODIFIER( Pop3MessageFactory, mid, mid, const std::string&)

    Pop3MessageFactory& fromReflection(const reflection::Pop3Message& v) {
        uidl(v.old_uidl);
        size(PGG_NUMERIC_CAST(uint64_t, v.size));
        fid(std::to_string(v.fid));
        mid(std::to_string(v.mid));
        return *this;
    }

    const Pop3Message& product() const { return _product; }

private:
    Pop3Message _product;
};

} // namespace pg
} // namespace macs

#undef MODIFIER

#endif /* MACS_PG_ENVELOPE_CONVERT_UID_MAP_H_171619092014 */
