#ifndef MACS_PG_ENVELOPE_QUERY_IMAP_H_164013012015
#define MACS_PG_ENVELOPE_QUERY_IMAP_H_164013012015

#include <pgg/query/boundaries.h>
#include <pgg/query/ranges.h>
#include <internal/query/ids.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;

// Imap uid map
struct ImapGetUidMap : QueryImpl<ImapGetUidMap, UserId, FolderId > {
    using Inherited::Inherited;
};


// Imap sepecific messages metadata
struct ImapGetMails : QueryImpl<ImapGetMails, UserId, FolderId, pgg::query::ImapIdRange> {
    using Inherited::Inherited;
};


// Imap sepecific messages metadata
struct ImapGetMailsChunk : QueryImpl<ImapGetMailsChunk, UserId, FolderId, pgg::query::ImapIdRange, RowCount> {
    using Inherited::Inherited;
};



// Imap changes list
struct ImapGetChanges : QueryImpl<ImapGetChanges, UserId, FolderId, ImapRevision> {
    using Inherited::Inherited;
};


// Imap details list
struct ImapGetDetails : QueryImpl<ImapGetDetails, UserId, MailIdList> {
    using Inherited::Inherited;
};


// Imap deleted list
struct ImapGetDeleted : QueryImpl<ImapGetDeleted, UserId, FolderId> {
    using Inherited::Inherited;
};


// List messages by messagae-id
struct ImapGetMailsByMessageId : QueryImpl<ImapGetMailsByMessageId, UserId, FolderId, ImapMessageId> {
    using Inherited::Inherited;
};

// Get list of unsubscribed imap folders
struct ImapGetUnsubscribed : QueryImpl<ImapGetUnsubscribed, UserId> {
    using Inherited::Inherited;
};

// Remove IMAP folder name from list of unsubscribed
struct ImapSubscribe : QueryImpl<ImapSubscribe, UserId, ImapFullName, pgg::RequestInfo> {
    using Inherited::Inherited;
};

// Add IMAP folder to list of unsubscribed
struct ImapUnsubscribe : QueryImpl<ImapUnsubscribe, UserId, ImapFullName, pgg::RequestInfo> {
    using Inherited::Inherited;
};

// Generate new imap_id for existing letter
struct ImapRegenerateImapId : QueryImpl<ImapRegenerateImapId, UserId, MailId, pgg::RequestInfo> {
    using Inherited::Inherited;
};

// Get POP3 full messages
struct Pop3GetMessages : QueryImpl<Pop3GetMessages, UserId, FolderIdList> {
    using Inherited::Inherited;
};


struct Pop3DeleteMessages : QueryImpl<Pop3DeleteMessages, UserId, MailIdList, pgg::RequestInfo> {
    using Inherited::Inherited;
};

} // namespace query
} // namespace pg
} // namespace macs

#endif /* MACS_PG_ENVELOPE_QUERY_IMAP_H_164013012015 */
