#pragma once

#include <macs/label_factory.h>
#include <internal/label/label_type.h>
#include <internal/label/symbols.h>
#include <pgg/numeric_cast.h>
#include <internal/reflection/label.h>

namespace macs::pg {

class LabelFactory: public macs::LabelFactory {
    LabelTypeConverter typeConverter;
public:

    LabelFactory &typeFromPG(const LabelType & pgType) {
        type(typeConverter.toMacsLabelType(pgType));
        return *this;
    }

    LabelFactory &defineSymbol() {
        const Label & lbl = product();
        symbol(
            symbols::defineLabelSymbol(lbl.type(), lbl.name())
        );
        return *this;
    }

    LabelFactory &fromReflection(const reflection::Label & v) {
        create();
        lid(std::to_string(v.lid));
        name(v.name);
        typeFromPG(LabelType::fromString(v.type));
        color(v.color);
        creationTime(std::to_string(v.created));
        revision(PGG_NUMERIC_CAST(macs::Revision, v.revision));
        messages(PGG_NUMERIC_CAST(std::size_t, v.message_count));

        if (v.message_seen) {
            unreadMessagesCount(product().messagesCount() - PGG_NUMERIC_CAST(std::size_t, *v.message_seen));
        }

        imapIndex(0);
        newMessages(0);
        defineSymbol();
        return *this;
    }
};

} // namespace macs::pg
