#ifndef INCLUDE_INTERNAL_LABEL_FAKE_H_194520042015
#define INCLUDE_INTERNAL_LABEL_FAKE_H_194520042015

#include <internal/label/table.h>
#include <macs/label_factory.h>

namespace macs {
namespace pg {
namespace label {

inline Label fake( const std::string & lid, const Label::Symbol & sym ) {
    return std::move(LabelFactory().type(Label::Type::system).symbol(sym)
            .name(lid).lid(lid).product());
}

} // namespace label

inline const label::Table & fakeLabels() {
    using label::fake;
    using Sym = Label::Symbol;
    static const label::Table table = {
            fake("FAKE_DELETED_LBL", Sym::deleted_label),
            fake("FAKE_RECENT_LBL", Sym::recent_label),
            fake("FAKE_SEEN_LBL", Sym::seen_label),
            fake("FAKE_SPAM_LBL", Sym::spam_label),
            fake("FAKE_POSTMASTER_LBL", Sym::postmaster_label),
            fake("FAKE_MULCA_SHARED_LBL", Sym::mulcaShared_label),
            fake("FAKE_APPEND_LBL", Sym::append_label),
            fake("FAKE_COPY_LBL", Sym::copy_label),
            fake("FAKE_ATTACHED_LBL", Sym::attached_label),
            fake("FAKE_SYNCED_LBL", Sym::synced_label)
    };
    return table;
}

inline const std::string & getFakeLabelId( const Label::Symbol & s ) {
    return fakeLabels().at(s).lid();
}

inline bool isFake( const std::string & lid ) {
    const auto & table = fakeLabels();
    return table.find(lid) != table.end();
}

inline bool isFake( const macs::Label & l ) {
    return isFake( l.lid() );
}

} // namespace pg
} // namespace macs

#endif /* INCLUDE_INTERNAL_LABEL_FAKE_H_194520042015 */
