#ifndef MACS_PG_LABEL_TYPE_171315122014
#define MACS_PG_LABEL_TYPE_171315122014

#include <pgg/enumeration.h>
#include <boost/bimap.hpp>
#include <macs/label.h>
#include <set>

namespace macs {
namespace pg {

struct __LabelType{
    enum Enum {
        unknown,
        user,
        system,
        domain,
        type,
        rpop,
        imap
    };

    typedef pgg::Enum2String<Enum>::Map Map;

    void fill(Map & map) const{
#define ADD_ENUM_TO_MAP(name) map.insert(Map::value_type(name, #name))
        ADD_ENUM_TO_MAP(user);
        ADD_ENUM_TO_MAP(system);
        ADD_ENUM_TO_MAP(domain);
        ADD_ENUM_TO_MAP(type);
        ADD_ENUM_TO_MAP(rpop);
        ADD_ENUM_TO_MAP(imap);
#undef ADD_ENUM_TO_MAP
    }

    typedef __LabelType Filler;
};

using LabelType = pgg::Enumeration<__LabelType>;
using LabelsTypes = std::set<LabelType>;

class LabelTypeConverter {
public:
    LabelType fromMacsLabelType(const macs::Label::Type & key) const {
        return get(map().right, key, PgType::unknown);
    }
    const macs::Label::Type & toMacsLabelType(LabelType key) const {
        return get(map().left, key, MacsType::user );
    }
private:
    using PgType = LabelType;
    using MacsType = Label::Type;
    using Map = boost::bimap<PgType,MacsType>;

    static Map makeMap() {
        using V = Map::value_type;
        Map m;
        m.insert(V( PgType::user, MacsType::user ));
        m.insert(V( PgType::system, MacsType::system ));
        m.insert(V( PgType::domain, MacsType::social ));
        m.insert(V( PgType::type, MacsType::spamDefense ));
        m.insert(V( PgType::rpop, MacsType::rpop ));
        m.insert(V( PgType::imap, MacsType::imap ));
        // [MAILPG-179] Unsupported, probably must be deleted from macs :
        //    LT::status, LT::threadWide, LT::phone, LT::spamDefense2
        return m;
    }

    static const Map & map() {
        static const Map m = makeMap();
        return m;
    }

    template <typename T>
    using CRef = const typename T::value_type::second_type &;

    template <typename MapT, typename KeyT>
    CRef<MapT> get( const MapT & map, const KeyT & key, CRef<MapT> defVal ) const {
        const auto i = map.find(key);
        return  i==map.end() ? defVal : i->second;
    }

};

} // namespace pg
} // namespace macs


#endif /* MACS_PG_LABEL_TYPE_171315122014 */
