#ifndef MACS_PG_LABEL_QUERIES_H_180015122014
#define MACS_PG_LABEL_QUERIES_H_180015122014

#include <pgg/query/boundaries.h>
#include <internal/query/ids.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;

struct AllLabelsList : QueryImpl<AllLabelsList, UserId > {
    using Inherited::Inherited;
};

struct ThreadsCountWithLabel: QueryImpl <ThreadsCountWithLabel, UserId, LabelId> {
    using Inherited::Inherited;
};

struct ClearLabel: QueryImpl<ClearLabel, UserId, pgg::RequestInfo, LabelId> {
    using Inherited::Inherited;
};

struct EraseLabel: QueryImpl <EraseLabel, UserId, pgg::RequestInfo, LabelId> {
    using Inherited::Inherited;
};

struct CreateLabel : QueryImpl<CreateLabel, UserId, pgg::RequestInfo, LabelName, LabelType, LabelColor> {
    using Inherited::Inherited;
};

struct ResolveLabels : QueryImpl<ResolveLabels, UserId, pgg::RequestInfo, LabelName, LabelType, LabelColor> {
    using Inherited::Inherited;
};

struct UpdateLabel : QueryImpl<UpdateLabel, UserId, pgg::RequestInfo, LabelId, LabelName, LabelColor> {
    using Inherited::Inherited;
};

} // namespace query
} // namespace pg
} // namespace macs


#endif /* MACS_PG_LABEL_QUERIES_H_180015122014 */
