#pragma once

#include <macs/hooks.h>
#include <macs/labels_repository.h>

#include <internal/label/label_type.h>
#include <pgg/query/repository.h>
#include <internal/query/ids.h>
#include <internal/query/comment.h>

namespace macs {
namespace pg {

typedef query::UserId UID;

template <typename DatabaseGenerator>
class LabelsRepository : public macs::LabelsRepository {
public:
    typedef macs::LabelsRepository Base;

    LabelsRepository(UserJournalPtr journal, const DatabaseGenerator& generator,
                     const std::string & uid, pgg::query::RepositoryPtr queryRepository,
                     const pgg::RequestInfo& requestInfo)
    : Base(journal), uid_(uid), queryRepository_(queryRepository), db(generator),
      requestInfo_(requestInfo)
    {}

    virtual ~LabelsRepository() {}

private:
    virtual void syncGetLabels(OnLabels h) const override;

    virtual void syncCreateLabel(const std::string& name, const std::string& color,
            const Label::Type& type, OnUpdateLabel hook) const override;
    virtual void syncCreateLabel(const Label::Symbol & symbol, OnUpdateLabel hook) const override;

    virtual void syncModifyLabel(const Label& label, OnUpdateLabel hook) const override;
    virtual void syncEraseLabel(const std::string& lid, OnUpdate hook) const override;
    virtual void syncClearLabel(const Label& label, OnUpdateMessages hook) const override;

    virtual void syncGetThreadsCount(const std::string& lid,
        OnCountReceive hook) const override;

    virtual void syncGetOrCreateLabel(const std::string&, const std::string&, const Label::Type&,
                                 OnUpdateLabel hook) const override;
    virtual void syncGetOrCreateLabel(const Label::Symbol & symbol, OnUpdateLabel hook) const override;

private:

    const std::string & uid() const {
        return uid_;
    }
    const pgg::query::Repository & queryRepository() const {
        return *queryRepository_;
    }
    template <typename T, typename ...ArgsT >
    T query(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(queryRepository(), uid(),
                std::forward<ArgsT>(args) ...);
    }

    template <typename T, typename ...ArgsT >
    T queryUpdate(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(queryRepository(), uid(),
                requestInfo_, std::forward<ArgsT>(args) ...);
    }

    const std::string uid_;
    pgg::query::RepositoryPtr queryRepository_;
    const DatabaseGenerator db;
    const pgg::RequestInfo requestInfo_;
};

template <typename DatabaseGenerator>
LabelsRepositoryPtr createLabelsRepository(
    macs::UserJournalPtr journal,
    DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo);

} // namespace pg
} // namespace macs

#include "repository.ipp"
