#pragma once

#include <boost/unordered_map.hpp>
#include <boost/assign/list_of.hpp>
#include <macs/label.h>


namespace macs {
namespace pg {
namespace symbols {

typedef std::map< std::string, Label::Symbol > LabelsSymbolsMap;

inline const LabelsSymbolsMap& getLabelsSymbolsMap() {
    static const LabelsSymbolsMap labelsSymbolMap = boost::assign::map_list_of
        ("spam", Label::Symbol::spam_label)
        ("answered", Label::Symbol::answered_label)
        ("draft", Label::Symbol::draft_label)
        ("forwarded", Label::Symbol::forwarded_label)
        ("priority_high", Label::Symbol::important_label)
        ("pinned", Label::Symbol::pinned_label)
        ("remindme_threadabout:mark", Label::Symbol::remindNoAnswer_label)
        ("SystMetkaWJDT:NOTIFY", Label::Symbol::notifyNoAnswer_label)
        ("SystMetka:remindme_about_message", Label::Symbol::remindMessage_label)
        ("SystMetkaWJDT:NOTIFY_MESSAGE", Label::Symbol::notifyMessage_label)
        ("mute", Label::Symbol::mute_label)
        ("delayed_message", Label::Symbol::delayedMessage_label)
        ("system_hamon", Label::Symbol::hamon_label)
        ("encrypted", Label::Symbol::encrypted_label)
        ("undo_message", Label::Symbol::undoMessage_label)
        ("mention_label", Label::Symbol::mention_label)
        ("mention_unvisited_label", Label::Symbol::mention_unvisited_label)
        ("sending_failed_label", Label::Symbol::sending_failed_label)
        ("from_favorite_user_label", Label::Symbol::from_favorite_user_label)
        ("reply_later_started", Label::Symbol::reply_later_started)
        ("reply_later_finished", Label::Symbol::reply_later_finished)
    ;
    return labelsSymbolMap;
}

inline Label::Symbol defineLabelSymbol(Label::Type const & labelType, std::string const & labelName) {
    if (labelType == Label::Type::system) {
        LabelsSymbolsMap::const_iterator found = getLabelsSymbolsMap().find(labelName);
        if (found != getLabelsSymbolsMap().end()) {
            return found->second;
        }
    }
    return macs::Label::Symbol::none;
}

inline std::string defineLabelName(Label::Symbol const & symbol) {
    const auto & symbolsMap = getLabelsSymbolsMap();
    const auto it = std::find_if(symbolsMap.begin(), symbolsMap.end(),
            [&symbol](const LabelsSymbolsMap::value_type &v) { return v.second == symbol; } );

    return it != symbolsMap.end() ? it->first : "";
}

} // symbols
} // namespace macs
} // namespace pg

