#pragma once

#include <macs_pg/mailish/account.h>
#include <macs_pg/mailish/account_factory.h>
#include <pgg/query/helper.h>
#include <internal/reflection/mailish_account.h>
#include <boost/hana/for_each.hpp>
#include <boost/hana/tuple.hpp>
#include <boost/hana/transform.hpp>

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::MailishAccount> {
    auto makeFields() const {
        return boost::hana::make_tuple(
            boost::hana::make_pair(account_.email(), "email"),
            boost::hana::make_pair(account_.imapLogin(), "imap_login"),
            boost::hana::make_pair(account_.imapSsl(), "imap_ssl"),
            boost::hana::make_pair(account_.imapServer(), "imap_server"),
            boost::hana::make_pair(account_.imapPort(), "imap_port"),
            boost::hana::make_pair(account_.smtpLogin(), "smtp_login"),
            boost::hana::make_pair(account_.smtpSsl(), "smtp_ssl"),
            boost::hana::make_pair(account_.smtpServer(), "smtp_server"),
            boost::hana::make_pair(account_.smtpPort(), "smtp_port"),
            boost::hana::make_pair(account_.lastSyncTs(), "last_sync")
        );
    }

    template <typename Mapper>
    void map( const Mapper & m ) const {
        boost::hana::for_each(makeFields(), [&](auto&& field) {
            m.mapValue(boost::hana::first(field), boost::hana::second(field));
        });
    }

    auto get() const {
        return boost::hana::transform(makeFields(), [](auto&& field) {
            return boost::hana::first(field);
        });
    }

    void set(const macs::MailishAccount & account) {
        account_ = account;
    }

    Base & mailishAccount( const macs::MailishAccount & account ) {
        account_ = account;
        return static_cast<Base&>(*this);
    }
private:
    macs::MailishAccount account_;
};

} // namespace query
} // namespace pgg

namespace macs {
namespace pg {

MailishAccount toMailishAccount(const reflection::MailishAccount& v);

} // namespace pg
} // namespace macs
