#pragma once

#include <pgg/query/helper.h>
#include <internal/reflection/mailish_auth_data.h>
#include <internal/mailish/auth_type.h>
#include <macs_pg/mailish/auth_data.h>
#include <boost/hana/for_each.hpp>
#include <boost/hana/tuple.hpp>
#include <boost/hana/transform.hpp>

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::MailishAuthData> {
    auto makeFields() const {
        return boost::hana::make_tuple(
            boost::hana::make_pair(authData_.tokenId(), "token_id"),
            boost::hana::make_pair(macs::pg::AuthType(authData_.authType()).toString(), "auth_type"),
            boost::hana::make_pair(authData_.uuid(), "uuid"),
            boost::hana::make_pair(authData_.oauthApplication(), "oauth_app"),
            boost::hana::make_pair(authData_.imapCredentials(), "imap_credentials"),
            boost::hana::make_pair(authData_.smtpCredentials(), "smtp_credentials")
        );
    }

    template <typename Mapper>
    void map( const Mapper & m ) const {
        boost::hana::for_each(makeFields(), [&](auto&& field) {
            m.mapValue(boost::hana::first(field), boost::hana::second(field));
        });
    }

    auto get() const {
        return boost::hana::transform(makeFields(), [](auto&& field) {
            return boost::hana::first(field);
        });
    }

    void set(const macs::MailishAuthData & authData) {
        authData_ = authData;
    }

    Base & mailishAuthData( const macs::MailishAuthData & authData ) {
        authData_ = authData;
        return static_cast<Base&>(*this);
    }
private:
    macs::MailishAuthData authData_;
};

} // namespace query
} // namespace pgg
