#pragma once

#include <boost/assign.hpp>
#include <pgg/enumeration.h>
#include <macs_pg/mailish/auth_data.h>

namespace macs {
namespace pg {

struct AuthTypeImpl {
    using Enum = macs::MailishAuthData::AuthType;
    using Filler = AuthTypeImpl;
    using Map = pgg::Enum2String<Enum>::Map;

    void fill(Map & map) {
        boost::assign::insert(map)
            ( Enum::Undefined, "undefined" )
            ( Enum::OAuth2,    "oauth2" )
            ( Enum::Password,  "password" );
    }
};

typedef pgg::Enumeration<AuthTypeImpl, AuthTypeImpl::Enum::Undefined> AuthType;

} // namespace pg
} // namespace macs
