#pragma once

#include <pgg/query/helper.h>
#include <internal/reflection/mailish_folder_info.h>
#include <macs_pg/mailish/folder_info.h>
#include <boost/hana/tuple.hpp>

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::MailishFolderInfo> {
    template <typename MapperT>
    void map(const MapperT & m) const {
        m.mapValue(makeFolderInfo(), "mailish_folder_info");
    }

    auto get() const {
        return makeFolderInfo();
    }

    void set(const macs::MailishFolderInfo & info) {
        info_ = info;
    }

private:
    auto makeFolderInfo() const {
        return macs::pg::reflection::MailishFolderInfo(info_.externalPath(), static_cast<int64_t>(info_.uidValidity()));
    }
    macs::MailishFolderInfo info_;
};

} // namespace query
} // namespace pgg
