#pragma once

#include <internal/reflection/mailish_message_info.h>
#include <pgg/query/helper.h>
#include <macs_pg/mailish/message_info.h>
#include <boost/optional.hpp>

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::MailishMessageInfoOpt> {
    auto makeFields() const {
        return boost::hana::make_tuple(
            boost::hana::make_pair((*mailishInfo_).externalImapId, "external_imap_id"),
            boost::hana::make_pair((*mailishInfo_).receiveDate, "external_receive_date")
        );
    }

    auto makeOptionalFields() const {
        return boost::hana::make_tuple(
            boost::hana::make_pair(boost::optional<int64_t>(), "external_imap_id"),
            boost::hana::make_pair(boost::optional<std::time_t>(), "external_receive_date")
        );
    }

    template <typename Mapper>
    void map( const Mapper & m ) const {
        boost::hana::for_each(mailishInfo_ ? makeFields() : makeOptionalFields(), [&](auto&& field) {
            m.mapValue(boost::hana::first(field), boost::hana::second(field));
        });
    }

    auto get() const {
        return boost::hana::transform(mailishInfo_ ? makeFields() : makeOptionalFields(), [](auto&& field) {
            return boost::hana::first(field);
        });
    }

    void set(const macs::MailishMessageInfoOpt & mailishInfo) {
        mailishInfo_ = mailishInfo;
    }

    Base & mailishMessageInfoOpt( const macs::MailishMessageInfoOpt & mailishInfo ) {
        mailishInfo_ = mailishInfo;
        return static_cast<Base&>(*this);
    }
private:
    macs::MailishMessageInfoOpt mailishInfo_;
};

} // namespace query
} // namespace pgg
