#pragma once

#include <pgg/query/helper.h>
#include <internal/reflection/mailish_move_coords.h>
#include <macs_pg/mailish/move_coords.h>
#include <boost/optional.hpp>
#include <boost/hana/tuple.hpp>

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::MailishMoveCoordsChunk> {
    template <typename MapperT>
    void map(const MapperT & m) const {
        m.mapValue(makeChunk(), "move_coords");
    }

    auto get() const {
        return makeChunk();
    }

    void set(const macs::MailishMoveCoordsChunk & chunk) {
        chunk_ = chunk;
    }

    Base & mailishMoveCoordsChunk( const macs::MailishMoveCoordsChunk & chunk ) {
        chunk_ = chunk;
        return static_cast<Base&>(*this);
    }
private:
    auto makeChunk() const {
        std::vector<macs::pg::reflection::MailishMoveCoords> chunk;
        for (auto& coords: chunk_) {
            chunk.emplace_back(coords.curImapId(), coords.newImapId());
        }
        return chunk;
    }
    macs::MailishMoveCoordsChunk chunk_;
};

} // namespace query
} // namespace pgg
