#pragma once

#include <pgg/query/boundaries.h>
#include <pgg/query/ranges.h>
#include <internal/mailish/auth_data.h>
#include <internal/mailish/account.h>
#include <internal/mailish/folder_info.h>
#include <internal/mailish/move_coords.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;

struct SaveMailishAccount: public QueryImpl<SaveMailishAccount, UserId, MailishAuthData, MailishAccount> {
    using Inherited::Inherited;
};

struct InvalidateMailishAuthData: public QueryImpl<InvalidateMailishAuthData, UserId, TokenId> {
    using Inherited::Inherited;
};

struct MailishEraseSecurityLocks: public QueryImpl<MailishEraseSecurityLocks, UserId> {
    using Inherited::Inherited;
};

struct GetMailishAuthData: public QueryImpl<GetMailishAuthData, UserId> {
    using Inherited::Inherited;
};

struct GetMailishAccount: public QueryImpl<GetMailishAccount, UserId> {
    using Inherited::Inherited;
};

struct GetMailishFolders: public QueryImpl<GetMailishFolders, UserId> {
    using Inherited::Inherited;
};

struct MailishUpdateDownloadedRange: public QueryImpl<MailishUpdateDownloadedRange, UserId, FolderId, ImapIdFrom, ImapIdTo> {
    using Inherited::Inherited;
};

struct GetMailishMessagesChunkById: public QueryImpl<GetMailishMessagesChunkById, UserId, FolderId, ImapIdFrom, MessagesCount> {
    using Inherited::Inherited;
};

struct GetMailishMessagesByImapIds: public QueryImpl<GetMailishMessagesByImapIds, UserId, FolderId, ImapIds> {
    using Inherited::Inherited;
};

struct GetMailishMessagesByMids: public QueryImpl<GetMailishMessagesByMids, UserId, MailIdVec> {
    using Inherited::Inherited;
};

struct GetNotDownloadedMailishMessages: public QueryImpl<GetNotDownloadedMailishMessages, UserId, MessagesCount> {
    using Inherited::Inherited;
};

struct GetMailishMessagesByTop: public QueryImpl<GetMailishMessagesByTop, UserId, FolderId, MessagesCount> {
    using Inherited::Inherited;
};

struct MailishInitFolder: public QueryImpl<MailishInitFolder, UserId, FolderId, MailishFolderInfo> {
    using Inherited::Inherited;
};

struct MailishUpdateFolder: public QueryImpl<MailishUpdateFolder, UserId, FolderId, MailishFolderInfo> {
    using Inherited::Inherited;
};

struct MailishDeleteFolderEntries: public QueryImpl<MailishDeleteFolderEntries, UserId, FolderIdVector> {
    using Inherited::Inherited;
};

struct MailishMoveMessages: public QueryImpl<MailishMoveMessages, UserId, SrcFolderId, DstFolderId, MailishMoveCoordsChunk> {
    using Inherited::Inherited;
};

struct MailishDeleteEntries: public QueryImpl<MailishDeleteEntries, UserId, FolderId, ImapIds> {
    using Inherited::Inherited;
};

struct MailishIncrementErrors: public QueryImpl<MailishIncrementErrors, UserId, FolderId, ImapMessageId, ErrorsCount> {
    using Inherited::Inherited;
};

struct UpdateMailishLastSyncTs: public QueryImpl<UpdateMailishLastSyncTs, UserId, LastSyncTs> {
    using Inherited::Inherited;
};

} // namespace query
} // namespace pg
} // namespace macs
