#pragma once

#include <macs_pg/mailish_accounts/repository.h>

#include <pgg/database/database.h>
#include <pgg/query/repository.h>

namespace macs {
namespace pg {

template <typename DatabaseGenerator>
class MailishAccountsRepository : public macs::MailishAccountsRepository {
public:
    MailishAccountsRepository(const DatabaseGenerator& generator,
                           pgg::query::RepositoryPtr queryRepository)
    : queryRepository_(queryRepository), db(std::move(generator))
    {}

private:
    void asyncGetUsers(OnShardUserList hook) const override;
    void asyncGetChanges(std::time_t lastMovedDate, std::time_t lastDeletedDate, OnShardUserList hook) const override;

    const pgg::query::Repository& queryRepository() const {
        return *queryRepository_;
    }

    pgg::query::RepositoryPtr queryRepository_;
    const DatabaseGenerator db;
};


} // namespace pg
} // namespace macs

#include "repository.ipp"
