#include <internal/mailish_accounts/repository.h>
#include <internal/mailish_accounts/query.h>
#include <internal/shard_user.h>
#include <internal/hooks/wrap.h>
#include <internal/mailish/account.h>

namespace macs {
namespace pg {

template <typename DatabaseGenerator>
void MailishAccountsRepository<DatabaseGenerator>::asyncGetUsers(OnShardUserList hook) const {
    const auto q = queryRepository().template query<query::MailishGetUsers>();
    auto wrapper = wrapHook<reflection::ShardUser>(std::move(hook), toShardUser);
    db()->fetch(q, std::move(wrapper));
}

template <typename DatabaseGenerator>
void MailishAccountsRepository<DatabaseGenerator>::asyncGetChanges(std::time_t lastMovedDate, std::time_t lastDeletedDate, OnShardUserList hook) const {
    const auto q = queryRepository().template query<query::MailishGetChangedUsers>(query::LastMovedDate(lastMovedDate), query::LastDeletedDate(lastDeletedDate));
    auto wrapper = wrapHook<reflection::ShardUser>(std::move(hook), toShardUser);
    db()->fetch(q, std::move(wrapper));
}

} // namespace pg
} // namespace macs
