#ifndef INCLUDE_INTERNAL_QUERY_COMMENT_H_
#define INCLUDE_INTERNAL_QUERY_COMMENT_H_

#include <pgg/query/boundaries.h>
#include <pgg/query/repository.h>
#include <internal/query/ids.h>

namespace macs {
namespace pg {
namespace query {

inline std::string makeQueryComment(const pgg::query::Query & q, const std::string & uid) {
    return "sql: " + std::string(q.name()) + ", uid: " + uid;
}

template <typename T, typename Repo, typename ... Args>
T makeQueryWithComment(const Repo& repo, const std::string& uid, Args&& ...args) {
    auto q = repo.template query<T>(UserId(uid), std::forward<Args>(args)...);
    q.comment(makeQueryComment(q, uid));
    return q;
}

} // namespace query

using query::makeQueryWithComment;

} // namespace pg
} // namespace macs

#endif /* INCLUDE_INTERNAL_QUERY_COMMENT_H_ */
