#pragma once

#include <macs/types.h>
#include <macs/folder.h>
#include <macs/tab.h>
#include <macs/backup.h>
#include <macs_pg/subscription/subscription_action.h>
#include <macs_pg/subscription/types.h>
#include <macs_pg/changelog/change_type.h>
#include <macs_pg/changelog/types.h>
#include <pgg/query/mapper.h>
#include <pgg/query/helper.h>
#include <pgg/query/ids.h>
#include <internal/mailish/auth_type.h>
#include <internal/collectors/state.h>
#include <internal/user/state.h>
#include <string>
#include <boost/hana/tuple.hpp>

#define MACS_PG_QUERY_ID( className, idName, idId, type ) \
        namespace macs {\
        namespace pg {\
        namespace query {\
            struct className##Tag { typedef type Value; };\
            typedef ::pgg::query::ValueWrapper<className##Tag> className;\
        }}}\
        \
        namespace pgg {\
        namespace query {\
            template<typename Base>\
            struct Helper<Base, ::macs::pg::query::className> {\
                template <typename MapperT>\
                void map(const MapperT & m) const { m.mapValue(v_.value, idId); }\
                auto get() const {return boost::hana::make_tuple(v_.value);}\
                void set(const ::macs::pg::query::className & v) { v_ = v; }\
                Base& idName(const ::macs::pg::query::className & v) {\
                    v_ = v;\
                    return static_cast<Base&>(*this);\
                }\
            private:\
                ::macs::pg::query::className v_;\
            };\
        }}

MACS_PG_QUERY_ID( RowFrom, rowFrom, "rowFrom", uint64_t )
MACS_PG_QUERY_ID( RowCount, rowCount, "rowCount", uint64_t )
MACS_PG_QUERY_ID( MailId, mailId, "mid", std::string )
MACS_PG_QUERY_ID( OptionalMailId, mailId, "mid", std::optional<std::string> )
MACS_PG_QUERY_ID( MessageId, messageId, "msgId", std::string )
MACS_PG_QUERY_ID( MailReference, mailReference, "mailRef", uint64_t )
MACS_PG_QUERY_ID( LabelId, labelId, "lid", std::string )
MACS_PG_QUERY_ID( OptionalLabelId, labelId, "lid", boost::optional<std::string> )
MACS_PG_QUERY_ID( FolderId, folderId, "fid", std::string )
MACS_PG_QUERY_ID( OptionalFolderId, folderId, "fid", boost::optional<std::string> )
MACS_PG_QUERY_ID( OwnerFolderId, ownerFolderId, "owner_fid", std::string )
MACS_PG_QUERY_ID( OwnerFolderIds, ownerFolderIds, "owner_fids", std::vector<std::string> )
MACS_PG_QUERY_ID( Position, position, "position", size_t )
MACS_PG_QUERY_ID( SrcFolderId, srcFid, "srcFid", std::string )
MACS_PG_QUERY_ID( DstFolderId, dstFid, "dstFid", std::string )
MACS_PG_QUERY_ID( ThreadId, threadId, "tid", std::string )
MACS_PG_QUERY_ID( UserId, uid, "uid", std::string )
MACS_PG_QUERY_ID( UserIds, uids, "uids", std::vector<std::string> )
MACS_PG_QUERY_ID( OwnerUserId, ownerUid, "owner_uid", std::string )
MACS_PG_QUERY_ID( Subscriber, subscriber, "subscriber", std::string )
MACS_PG_QUERY_ID( LabelsTypes, labelsTypes, "labels_types", std::vector<std::string> )
MACS_PG_QUERY_ID( MailIds, mailIds, "mids", std::vector<std::string> )
MACS_PG_QUERY_ID( StorageId, storageId, "st_id", std::string )
MACS_PG_QUERY_ID( PartId, partId, "hid", macs::Hid )
MACS_PG_QUERY_ID( HdrPairs, hdrPairs, "hdrPairs", macs::HdrDateAndMessageIdVec )
MACS_PG_QUERY_ID( OutgoingFolders, outgoingFolders, "outgoing_folders", std::vector<std::string> )
MACS_PG_QUERY_ID( RemindNoAnswerLid, remindNoAnswerLid, "remind_no_answer_lid", std::string )
MACS_PG_QUERY_ID( ReceivedDate, receivedDate, "received_date", std::time_t )
MACS_PG_QUERY_ID( MailAttributes, mailAttributes, "attributes", std::vector<std::string> )

MACS_PG_QUERY_ID( LabelName, labelName, "label_name", std::string )
MACS_PG_QUERY_ID( LabelType, labelType, "label_type", std::string )
MACS_PG_QUERY_ID( LabelColor, labelColor, "label_color", std::string )

MACS_PG_QUERY_ID( MailIdList, mailIdList, "mids", std::list<std::string> )
MACS_PG_QUERY_ID( MailIdVec, mailIdVec, "mids", macs::MidVec )
MACS_PG_QUERY_ID( OwnerMids, ownerMids, "owner_mids", macs::MidVec )
MACS_PG_QUERY_ID( MailRefVec, mailRefVec, "mailRefs", macs::MailRefVec )
MACS_PG_QUERY_ID( LabelIdList, labelIdList, "lids", std::list<std::string> )
MACS_PG_QUERY_ID( LabelIdToCheckList, labelIdToCheckList, "lids_to_check", std::vector<std::string> )
MACS_PG_QUERY_ID( LabelIdVector, labelIdVector, "lids", std::vector<std::string> )
MACS_PG_QUERY_ID( OldLabelIdList, oldLabelIdList, "old_lids", std::list<std::string> )
MACS_PG_QUERY_ID( FolderIdList, folderIdList, "fids", std::list<std::string> )
MACS_PG_QUERY_ID( FolderIdListOn, folderIdListOn, "fids_on", std::vector<std::string> )
MACS_PG_QUERY_ID( FolderIdListOff, folderIdListOff, "fids_off", std::vector<std::string> )
MACS_PG_QUERY_ID( ThreadIdList, threadIdList, "tids", std::list<std::string> )

MACS_PG_QUERY_ID( FilterUnread, filterUnread, "filter_unread", bool )
MACS_PG_QUERY_ID( FilterAttaches, filterAttaches, "filter_attaches", bool )

MACS_PG_QUERY_ID( ThreadIdVector, threadIdVector, "tids", std::vector<std::string> )
MACS_PG_QUERY_ID( FolderIdVector, folderIdVector, "fids", std::vector<std::string> )

MACS_PG_QUERY_ID( SetSeen, setSeen, "set_seen", boost::optional<bool> )
MACS_PG_QUERY_ID( SetRecent, setRecent, "set_recent", boost::optional<bool> )
MACS_PG_QUERY_ID( SetDeleted, setDeleted, "set_deleted", boost::optional<bool> )

MACS_PG_QUERY_ID( ImapMessageId, imapMessageId, "messageId", std::string )
MACS_PG_QUERY_ID( ImapUidvalidity, imapUidvalidity, "uidvalidity", uint64_t )
MACS_PG_QUERY_ID( ImapRevision, imapRevision, "imapRevision", uint64_t )
MACS_PG_QUERY_ID( ImapFullName, imapFullName, "imapFullName", std::vector<std::string> )
MACS_PG_QUERY_ID( imap_id, imap_id, "imap_id", boost::optional<int64_t> )

MACS_PG_QUERY_ID( Subject, subject, "subject", boost::optional<std::string> )
MACS_PG_QUERY_ID( From, from, "from", std::string )
MACS_PG_QUERY_ID( Seen, seen, "seen", bool )
MACS_PG_QUERY_ID( HdrDate, hdrDate, "hdr_date", std::time_t)

MACS_PG_QUERY_ID( ChangeId , changeId, "changeId", int64_t )
MACS_PG_QUERY_ID( ChangeIdVec , changeIdVec, "changeIdVec", std::vector<int64_t> )

MACS_PG_QUERY_ID( AliveTimeoutSeconds, aliveTimeoutSeconds, "alive_timeout_seconds", std::chrono::seconds )
MACS_PG_QUERY_ID( LaunchId, launchId, "launch_id", std::string )
MACS_PG_QUERY_ID( Hostname, hostname, "hostname", std::string )
MACS_PG_QUERY_ID( WorkerVersion, workerVersion, "worker_version", std::string )
MACS_PG_QUERY_ID( SubscriptionId, subscriptionId, "subscription_id", macs::SubscriptionId )
MACS_PG_QUERY_ID( SubscriptionIdVec, subscriptionIdVec, "subscription_ids", std::vector<macs::SubscriptionId> )
MACS_PG_QUERY_ID( ChangeReferenceVec, changeReferenceVec, "change_references", std::vector<macs::ChangeReference> )
MACS_PG_QUERY_ID( WorkerId, workerId, "worker_id", macs::WorkerId )
MACS_PG_QUERY_ID( SubscriptionAction, subscriptionAction, "subscription_action", macs::pg::SubscriptionAction)
MACS_PG_QUERY_ID( FailReason, failReason, "fail_reason", std::string )
MACS_PG_QUERY_ID( SubscriptionsLimit, subscriptionsLimit, "subscriptions_limit", std::size_t)


MACS_PG_QUERY_ID( OwnerRevision , ownerRevision, "owner_revision", uint64_t )

MACS_PG_QUERY_ID( ReferenceHashes, referenceHashes, "reference_hashes", std::vector<std::uint64_t> )
MACS_PG_QUERY_ID( InReplyToHash, inReplyToHash, "in_reply_to_hash", boost::optional<std::uint64_t> )

MACS_PG_QUERY_ID( OwnerThreadId, ownerTid, "owner_tid", std::string )
MACS_PG_QUERY_ID( OwnerJoinThreadIds, ownerJoinTids, "owner_join_tids", std::vector<std::string> )

MACS_PG_QUERY_ID( QuietFlag, quietFlag, "quiet", boost::optional<bool> )

MACS_PG_QUERY_ID( IsAttachedFilter, isAttachedFilter, "is_attached_filter", bool );
MACS_PG_QUERY_ID( IsSpamFilter, isSpamFilter, "is_spam_filter", bool );
MACS_PG_QUERY_ID( IsSyncedFilter, isSyncedFilter, "is_synced_filter", bool );

MACS_PG_QUERY_ID( RangeMin, rangeMin, "rangeMin", uint64_t )
MACS_PG_QUERY_ID( RangeMax, rangeMax, "rangeMax", uint64_t )

MACS_PG_QUERY_ID( TaskId , taskId, "task_id", uint64_t )
MACS_PG_QUERY_ID( TaskRequestId , taskRequestId, "task_request_id", std::string )

MACS_PG_QUERY_ID( ArchivationType, archivationType, "archive_type", macs::Folder::ArchivationType )
MACS_PG_QUERY_ID( ArchivationTtl, archivationTtl, "keep_days", uint32_t )
MACS_PG_QUERY_ID( MaxFolderSize, maxFolderSize, "max_folder_size", uint32_t )

MACS_PG_QUERY_ID( Email, email, "email", std::string );
MACS_PG_QUERY_ID( TokenId, tokenId, "token_id", std::string );
MACS_PG_QUERY_ID( ImapIdFrom, imapIdFrom, "imap_id_from", std::uint32_t );
MACS_PG_QUERY_ID( ImapIdTo, imapIdTo, "imap_id_to", std::uint32_t );
MACS_PG_QUERY_ID( ImapIds, imapIds, "imap_ids", std::vector<std::uint64_t> );
MACS_PG_QUERY_ID( MessagesCount, messagesCount, "messages_count", uint32_t );
MACS_PG_QUERY_ID( ErrorsCount, errorsCount, "errors_count", uint32_t );
MACS_PG_QUERY_ID( LastMovedDate, lastMovedDate, "last_moved_date", std::time_t);
MACS_PG_QUERY_ID( LastDeletedDate, lastDeletedDate, "last_deleted_date", std::time_t);
MACS_PG_QUERY_ID( LastSyncTs, lastSyncTs, "last_sync", std::time_t);

MACS_PG_QUERY_ID( ImapId, imapId, "imap_id", std::uint64_t );

MACS_PG_QUERY_ID( SrcUserId, srcUid, "src_uid", std::string );
MACS_PG_QUERY_ID( CollectorId, collectorId, "collector_id", uint32_t );
MACS_PG_QUERY_ID( CollectorsAuthToken, authToken, "auth_token", std::string );
MACS_PG_QUERY_ID( CollectorsLastMid, lastMid, "last_mid", std::string );
MACS_PG_QUERY_ID( CollectorsState, state, "state", macs::pg::CollectorState );
MACS_PG_QUERY_ID( CollectorsSkippedMids, skippedMids, "skipped_mids", std::vector<std::string> );
MACS_PG_QUERY_ID( CollectorsIgnoreFoldersStruct, ignoreFoldersStruct, "ignore_folders_struct", bool );
MACS_PG_QUERY_ID( CollectorsOriginalServer, originalServer, "original_server", std::string );
MACS_PG_QUERY_ID( OldPopid, oldPopid, "old_popid", std::uint64_t );
MACS_PG_QUERY_ID( CreationTs, creationTs, "creation_ts", std::time_t );

MACS_PG_QUERY_ID( Revision, revision, "revision", int64_t );
MACS_PG_QUERY_ID( Limit, limit, "limit", int64_t );
MACS_PG_QUERY_ID( ChangeLogTypes, changeLogTypes, "change_log_types", std::vector<macs::pg::ChangeType> );

MACS_PG_QUERY_ID( TabType, tabType, "tab_type", macs::Tab::Type )
MACS_PG_QUERY_ID( OptTabType, optTabType, "tab_type", std::optional<macs::Tab::Type> )
MACS_PG_QUERY_ID( TabTypes, tabTypes, "tab_types", std::vector<macs::Tab::Type> )

MACS_PG_QUERY_ID( Settings, settings, "settings", std::string )
MACS_PG_QUERY_ID( SettingsNames, settingsNames, "settings_names", std::vector<std::string> )

MACS_PG_QUERY_ID( FromUserState, fromUserState, "from_state", macs::pg::UserState );
MACS_PG_QUERY_ID( ToUserState, toUserState, "to_state", macs::pg::UserState );

MACS_PG_QUERY_ID( FromArchiveState, fromArchiveState, "from_archive_state", macs::pg::ArchiveState );
MACS_PG_QUERY_ID( ToArchiveState, toArchiveState, "to_archive_state", macs::pg::ArchiveState );
MACS_PG_QUERY_ID( OptionalNotice, notice, "notice", std::optional<std::string> )
MACS_PG_QUERY_ID( RestoredMessageCount, restoredMessageCount, "restored_message_count", int32_t );

MACS_PG_QUERY_ID( FromTaskId, fromTaskId, "from_task_id", macs::TaskId );
MACS_PG_QUERY_ID( ToTaskId, toTaskId, "to_task_id", macs::TaskId );

MACS_PG_QUERY_ID( BackupId, backupId, "backupId", int32_t );
MACS_PG_QUERY_ID( MaxMessagesInBackup, maxMessagesInBackup, "max_messages_in_backup", int32_t );
MACS_PG_QUERY_ID( UseTabs, useTabs, "use_tabs", bool );
MACS_PG_QUERY_ID( BackupFidToFidVec, fidToFidVec, "fid_to_fid_vec", macs::BackupFidToFidVec );
MACS_PG_QUERY_ID( BackupMidToMidVec, midToMidVec, "mid_to_mid_vec", macs::BackupMidToMidVec );
MACS_PG_QUERY_ID( RestoreMethod, restoreMethod, "restore_method", std::string );

MACS_PG_QUERY_ID( Date, date, "date", std::time_t )

#undef MACS_PG_QUERY_ID

namespace macs {
namespace pg {
namespace query {

struct ParentFolderId {
    using Value = boost::optional<std::string>;
    Value value;
    ParentFolderId() : value() {}
    explicit ParentFolderId(const Value & v)
        : ParentFolderId( v ? v.get() : "" ) {
    }
    explicit ParentFolderId(const std::string & v)
        : value( v.empty() || v == "0" ? Value() : v ) {
    }
};

struct FolderName {
    using Value = std::string;
    Value value;
    FolderName() : value() {}
    explicit FolderName(const Value & v)
        : value( escapeFolderName(v) ) {
    }
};

} // namespace query
} // namespace pg
} // namespace macs

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::pg::query::ParentFolderId> {
    using ParentFolderId = macs::pg::query::ParentFolderId;

    template <typename MapperT>
    void map(const MapperT & m) const { m.mapValue(v_.value, "parent_fid"); }
    auto get() const { return v_.value;}
    void set(const ParentFolderId & v) { v_ = v; }
    Base& parentFolderId(const ParentFolderId & v) {
        v_ = v;
        return static_cast<Base&>(*this);
    }
    private:
        ParentFolderId v_;
};

template<typename Base>
struct Helper<Base, macs::pg::query::FolderName> {
    using FolderName = macs::pg::query::FolderName;

    template <typename MapperT>
    void map(const MapperT& m) const { m.mapValue(v_.value, "folder_name"); }
    auto get() const { return v_.value; }
    void set(const FolderName& v) { v_ = v; }
    Base& folderName(const FolderName& v) {
        v_ = v;
        return static_cast<Base&>(*this);
    }
    private:
        FolderName v_;
};

} // namespace query
} // namespace pgg

