#pragma once

#include <pgg/query/query_register.h>
#include <pgg/query/transaction.h>
#include <internal/envelope/query.h>
#include <internal/label/query.h>
#include <internal/folder/query.h>
#include <internal/imap/query_imap.h>
#include <internal/thread/query.h>
#include <internal/changelog/query.h>
#include <internal/change_queue/query.h>
#include <internal/shared_folders/query.h>
#include <internal/subscription/query.h>
#include <internal/subscribed_folders/query.h>
#include <internal/mailish/query.h>
#include <internal/mailish_accounts/query.h>
#include <internal/tab/query.h>
#include <internal/collectors/query.h>
#include <internal/settings/query.h>
#include <internal/user/query.h>
#include <internal/backup/query.h>
#include <internal/sticker/query.h>

namespace macs {
namespace pg {
namespace query {

using Queries = pgg::query::RegisterQueries<
    // ENVELOPE
    MailboxListOneFolder,
    MailboxListFolders,
    MailboxListLabelReceivedDateSort,
    MailboxListAll,
    MailboxGetFirstEnvelopeDate,
    MailboxListAllWithFakeLabel,
    MailboxListOnlyNew,
    MailboxListNearest,
    MailboxListFoldersOnlyNew,
    MailboxListByMsgIdWithLabel,
    MailboxListInReplyTo,
    MailboxListFilterSearch,
    ThreadsView,
    MailboxListNearestInThread,
    MailboxListThread,
    MailboxListThreadWithLabel,
    MailboxListThreadWithoutLabel,
    MailboxEntriesByIds,
    MailboxMoveMessages,
    MailboxEraseMessages,
    MailboxForceEraseMessages,
    ResetFreshCounter,
    AddLabels,
    RemoveLabels,
    AddLabelsByThreads,
    RemoveLabelsByThreads,
    CopyMessages,
    ThreadsByTids,
    ThreadsWithLabel,
    ThreadsInFolderWithoutLabels,
    ThreadsInFolderWithLabels,
    MessagesInFolderWithoutLabels,
    MessagesInFolderWithLabels,
    StidsByMids,
    MidsByFolder,
    MidsRangeByFolder,
    MidsByFolderWithSeen,
    MidsRangeByFolderWithSeen,
    MidsByFolderWithoutLabel,
    MidsRangeByFolderWithoutLabel,
    AddToStorageDeleteQueue,
    StoreMessage,
    StoreDeletedMessage,
    QuickSaveMessage,
    UpdateMessageAttributes,
    MailboxGetEnvelopesCount,
    GetMidsByConditions,
    GetMidsByConditionsWithSeen,
    GetMidsByConditionsWithoutLabel,
    GetFreshCounter,
    GetAttachesCounters,
    GetMidsWithoutLabel,
    GetMidsWithSeen,
    FindDuplicates,
    LockUserDelivery,
    GetByMessageId,
    GetByMessageIdExceptExcludedFolders,
    GetNewestMessageInThread,
    GetNotAnsweredMids,
    WindatMessageStId,
    MimesByMids,
    MimesWithAttachesByMids,
    MimesByMidsWithDeleted,
    MimesWithAttachesByMidsWithDeleted,
    WindatMimesByMids,
    MessagesInFolderWithMimes,
    MessagesByMidsWithMimes,
    MessagesInFolderWithMimesByChunks,
    DeletedMessages,
    DeletedMessagesInInterval,
    DeletedMessagesByIds,
    ChangeLabels,
    NewMidsInFolderWithoutLabels,
    NewMidsInFolderWithLabels,
    GetMidsByTidsAndLids,
    MessagesInTab,
    MessagesInTabOnlyNew,
    MessagesInTabWithLabels,
    MessagesInTabWithoutLabels,
    ThreadsInTab,
    ThreadsInTabWithLabels,
    ThreadsInTabWithoutLabels,
    CountNewMessagesWithLids,
    MidsByTab,
    MidsByTabWithSeen,
    MidsByTabWithoutLabel,
    MidsByLid,
    MidsWithAttaches,
    MailboxGetFirstEnvelopeDateInTab,
    // LABEL
    AllLabelsList,
    ThreadsCountWithLabel,
    ClearLabel,
    EraseLabel,
    CreateLabel,
    ResolveLabels,
    UpdateLabel,
    // FOLDER
    MailboxRevision,
    AllFoldersList,
    CreateFolder,
    GetOrCreateFolder,
    DeleteFolder,
    ResetFolderUnvisited,
    MoveFolderMessages,
    UpdateFolder,
    UpdateFolderSymbol,
    SetFolderPosition,
    SetPop3,
    SetFolderArchivationRules,
    RemoveFolderArchivationRules,
    // IMAP
    ImapGetUidMap,
    ImapGetMails,
    ImapGetMailsChunk,
    ImapGetChanges,
    ImapGetDetails,
    ImapGetDeleted,
    ImapGetMailsByMessageId,
    ImapGetUnsubscribed,
    ImapSubscribe,
    ImapUnsubscribe,
    ImapRegenerateImapId,
    // POP3
    Pop3GetMessages,
    Pop3DeleteMessages,
    // THREAD
    ParticipantsList,
    ThreadLabels,
    MailsInThreads,
    MidsInFolder,
    MidsInThreadsWithSeen,
    MidsInThreadsWithoutLabel,
    FindThreadsByHash,
    FindThreadsByReferences,
    JoinThreads,
    MessageCountInThreads,
    MidsByThreadAndWithSameHeaders,
    MidsByHdrDateAndMessageIdPairs,
    // CHANGELOG
    ChangesById,
    MinimumKnownChangeId,
    // USER CHANGELOG
    ChangesByUid,
    GetChangeIdByRevision,
    ChangelogByUid,
    ChangelogByUidAndType,
    // CHANGE_QUEUE
    GetChangesFromQueue,
    GetChangesFromQueueByWorkerId,
    RemoveChangesFromQueue,
    // SHARED_FOLDERS
    CreateSharedFolder,
    AddSubscriberToSharedFolder,
    GetSharedFoldersByOwner,
    // SUBSCRIPTION
    FindAJob,
    ConfirmTheJob,
    SubscriptionsByWorkerId,
    SubscriptionById,
    TransitSubscriptionState,
    MarkSubscriptionFailed,
    GetFreeSubscriptions,
    ReleaseSubscription,
    SubscriptionsBySubscriberAndFids,
    RemoveSubscriptionsChunk,
    AddUnsubscribeTask,
    GetUnsubscribeTasks,
    RemoveSubscriptionsAndTask,
    // SUBSCRIBED_FOLDERS
    SubscribedFoldersAddFolder,
    SubscribedFoldersGetFolder,
    SubscribedFoldersRemoveFolders,
    SubscribedFoldersDeleteMessages,
    SubscribedFoldersAddLabels,
    SubscribedFoldersRemoveLabels,
    SubscribedFoldersGetSyncedRevision,
    SubscribedFoldersSyncMessage,
    SubscribedFoldersSyncJoinThreads,
    SubscribedFoldersGetEnvelopes,
    SubscribedFoldersGetFoldersByOwner,
    SubscribedFoldersGetSyncedMids,
    SubscribedFoldersGetLastSyncedImapId,
    // MAILISH
    SaveMailishAccount,
    InvalidateMailishAuthData,
    GetMailishAuthData,
    GetMailishAccount,
    MailishGetUsers,
    MailishGetChangedUsers,
    GetMailishFolders,
    GetMailishMessagesChunkById,
    GetMailishMessagesByImapIds,
    GetMailishMessagesByMids,
    GetNotDownloadedMailishMessages,
    GetMailishMessagesByTop,
    MailishUpdateDownloadedRange,
    MailishEraseSecurityLocks,
    MailishInitFolder,
    MailishUpdateFolder,
    MailishDeleteFolderEntries,
    MailishMoveMessages,
    MailishDeleteEntries,
    MailishIncrementErrors,
    UpdateMailishLastSyncTs,
    FindMailishDuplicates,
    // TABS
    AllTabsList,
    GetOrCreateTab,
    ResetTabFresh,
    CanReadTabs,
    //COLLECTORS
    CreateCollector,
    AddMigrationData,
    ResetCollector,
    DeleteCollector,
    UpdateCollectorsSkippedMids,
    UpdateCollectorsLastMid,
    UpdateCollectorsState,
    UpdateCollectorsMigrationTargetState,
    EditCollector,
    ResetCollectorsToken,
    GetCollectorsUsers,
    GetCollectorsUsersChanges,
    GetCollectors,
    MailboxEntriesAfterMid,
    MailboxEntriesAfterMidInPop3Box,
    //SETTINGS
    GetSettings,
    DeleteSettings,
    CreateSettings,
    UpdateSettings,
    EraseSettings,
    //USERINFO
    FreezingInfo,
    ChangeUserState,
    GetArchive,
    ActivateUserAndUpdateArchiveState,
    ExchangeArchiveTaskId,
    ExchangeArchiveState,
    UpdateRestorationProgress,
    //BACKUP
    BackupStatus,
    BackupSettings,
    BackupChangeSettings,
    BackupCreate,
    BackupFill,
    BackupNextId,
    BackupRestore,
    BackupFolders,
    BackupMessagesToRestore,
    BackupMessagesInFolderToRestore,
    BackupDeleteMessages,
    BackupUpdateMids,
    BackupDeactivate,
    BackupFail,
    BackupRestoreFail,
    BackupRestoreComplete,
    //STICKERS
    StickersReplyLaterList,
    CreateReplyLaterSticker,
    RemoveIncorrectReplyLaterStickers,
    RemoveReplyLaterSticker
>;

using QueryParameters = pgg::query::RegisterParameters<
    MailBoxOrder
>;

} // namespace query
} // namespace pg
} // namespace macs
