#pragma once

#include <pgg/query/helper.h>
#include <macs/threads_meta.h>
#include <boost/date_time.hpp>
#include <boost/optional.hpp>
#include <boost/hana/for_each.hpp>
#include <boost/hana/tuple.hpp>
#include <boost/hana/transform.hpp>

namespace macs {
namespace pg {
namespace query {

inline std::string toString(ThreadsHashNamespaces v) {
    switch (v) {
        case ThreadsHashNamespaces::subject:
            return "subject";
        case ThreadsHashNamespaces::from:
            return "from";
    }
    return "unknown";
}

inline std::string toString(ThreadsMergeRules v) {
    switch (v) {
        case ThreadsMergeRules::hash:
          return "hash";
        case ThreadsMergeRules::references:
            return "references";
        case ThreadsMergeRules::forceNewThread:
            return "force-new-thread";
    }
    return "unknown";
}

} // namespace macs
} // namespace pg
} // namespace query

namespace pgg {
namespace query {

template<typename Base>
struct Helper<Base, macs::ThreadLimits> {
    auto makeFields() const {
        return boost::hana::make_tuple(
            boost::hana::make_pair(boost::posix_time::from_time_t(v_.receivedDate), "receivedDate"),
            boost::hana::make_pair(v_.daysLimit, "daysLimit"),
            boost::hana::make_pair(v_.countLimit, "countLimit")
        );
    }

    template <typename Mapper>
    void map( const Mapper & m ) const {
        boost::hana::for_each(makeFields(), [&](auto&& field) {
            m.mapValue(boost::hana::first(field), boost::hana::second(field));
        });
    }

    auto get() const {
        return boost::hana::transform(makeFields(), [](auto&& field) {
            return boost::hana::first(field);
        });
    }

    void set(macs::ThreadLimits v) { v_ = std::move(v); }

private:
    macs::ThreadLimits v_;
};

template<typename Base>
struct Helper<Base, macs::ThreadHash> {
    auto makeFields() const {
        using macs::pg::query::toString;
        return boost::hana::make_tuple(
            boost::hana::make_pair(v_.value, "hashValue"),
            boost::hana::make_pair(toString(v_.ns), "hashNamespace"),
            boost::hana::make_pair(v_.key, "hashKey")
        );
    }

    template <typename Mapper>
    void map( const Mapper & m ) const {
        boost::hana::for_each(makeFields(), [&](auto&& field) {
            m.mapValue(boost::hana::first(field), boost::hana::second(field));
        });
    }

    auto get() const {
        return boost::hana::transform(makeFields(), [](auto&& field) {
            return boost::hana::first(field);
        });
    }

    void set(macs::ThreadHash v) { v_ = std::move(v); }

private:
    macs::ThreadHash v_;
};

template<typename Base>
struct Helper<Base, macs::ThreadMeta> {
    auto makeFields() const {
        using namespace macs;
        using macs::pg::query::toString;

        return boost::hana::make_tuple(
            boost::hana::make_pair(toString(v_ ? v_->mergeRule : ThreadsMergeRules::forceNewThread), "mergeRule"),
            boost::hana::make_pair(makeThreadMeta<decltype(ThreadMeta().referenceHashes)>(&ThreadMeta::referenceHashes), "referenceHashes"),
            boost::hana::make_pair(makeThreadMetaNullable<decltype(ThreadMeta().inReplyToHash)>(&ThreadMeta::inReplyToHash), "inReplyToHash"),
            boost::hana::make_pair(makeThreadHash<decltype(ThreadHash().value)>(&ThreadHash::value), "hashValue"),
            boost::hana::make_pair(v_ ? boost::optional<std::string>(process(v_.get().hash.ns)) : boost::optional<std::string>(), "hashNamespace"),
            boost::hana::make_pair(makeThreadHash<decltype(ThreadHash().key)>(&ThreadHash::key), "hashKey"),
            boost::hana::make_pair(v_ ? v_->sortOptions : std::string(), "sortOptions")
        );
    }

    template <typename Mapper>
    void map( const Mapper & m ) const {
        boost::hana::for_each(makeFields(), [&](auto&& field) {
            m.mapValue(boost::hana::first(field), boost::hana::second(field));
        });
    }

    auto get() const {
        return boost::hana::transform(makeFields(), [](auto&& field) {
            return boost::hana::first(field);
        });
    }

    void set(macs::ThreadMeta v) { v_ = std::move(v); }

    Base & threadMeta(macs::ThreadMeta v) {
        set(std::move(v));
        return static_cast<Base&>(*this);
    }

private:
    template <typename T>
    const T & process(const T & v) const { return v;}
    std::string process(macs::ThreadsHashNamespaces v) const {
        using macs::pg::query::toString;
        return toString(v);
    }

    template <typename FieldType, typename T>
    boost::optional<FieldType> makeThreadMeta(T macs::ThreadMeta::*field) const {
        if(v_.is_initialized()) {
            return process(v_.get().*field);
        } else {
            return {};
        }
    }

    template <typename FieldType, typename T>
    boost::optional<FieldType> makeThreadMetaNullable(T macs::ThreadMeta::*field) const {
        if(v_.is_initialized() && !(v_.get().*field).empty()) {
            return process(v_.get().*field);
        } else {
            return {};
        }
    }

    template <typename FieldType, typename T>
    boost::optional<FieldType> makeThreadHash(T macs::ThreadHash::*field) const {
        if(v_.is_initialized()) {
            return process(v_.get().hash.*field);
        } else {
            return{};
        }
    }

    boost::optional<macs::ThreadMeta> v_;
};

} // namespace query
} // namespace pgg
