#pragma once

#include <boost/optional.hpp>
#include <boost/fusion/adapted/struct/define_struct.hpp>

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), Backup,
    (int32_t, backup_id)
    (std::time_t, created)
    (std::time_t, updated)
    (int32_t, message_count)
    (std::string, state)
    (boost::optional<std::string>, notice)
    (int32_t, version)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), FidToFid,
    (int32_t, original)
    (int32_t, renewed)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), Restore,
    (int32_t, backup_id)
    (std::time_t, created)
    (std::time_t, updated)
    (int32_t, to_restore_count)
    (int32_t, restored_count)
    (std::string, state)
    (std::string, method)
    (boost::optional<std::string>, notice)
    (std::vector<macs::pg::reflection::FidToFid>, fids_mapping)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), BackupStatus,
    (boost::optional<macs::pg::reflection::Backup>, primary)
    (boost::optional<macs::pg::reflection::Backup>, additional)
    (boost::optional<macs::pg::reflection::Restore>, restore)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), BackupSettings,
    (std::vector<int32_t>, fids)
    (std::vector<std::string>, tabs)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), WithResult,
    (boost::optional<std::string>, result)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), BackupId,
    (int32_t, backup_id)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), BackupFolder,
    (int32_t, fid)
    (std::string, name)
    (boost::optional<int32_t>, parent_fid)
    (bool, is_backuped)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), MessagesToRestore,
    (uint64_t, mid)
    (std::string, st_id)
    (int32_t, fid)
    (boost::optional<std::string>, tab)
    (std::time_t, received_date)
    (std::vector<std::string>, attributes)
)
