#ifndef MACS_PG_REFLECTION_CHANGE_QUEUE_H_28032017
#define MACS_PG_REFLECTION_CHANGE_QUEUE_H_28032017

#include <macs_pg/changelog/types.h>

#include <cstdint>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <boost/fusion/adapted/struct/adapt_struct.hpp>

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), ChangeQueue,
    (std::int64_t, cid)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), ChangeReference,
        (std::int64_t, cid)
        (std::int64_t, uid)
        (std::int64_t, subscription_id)
)

BOOST_FUSION_ADAPT_STRUCT(macs::ChangeReference,
      (std::string, uid)
      (std::int64_t, subscriptionId)
      (std::int64_t, change)
)

#endif // MACS_PG_REFLECTION_CHANGE_QUEUE_H_28032017
