#ifndef MACS_PG_REFLECTION_ENVELOPE_H
#define MACS_PG_REFLECTION_ENVELOPE_H

#include <vector>
#include <boost/optional.hpp>
#include <internal/reflection/message_attach.h>
#include <internal/reflection/recipient.h>
#include <internal/reflection/mime_part.h>

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), Envelope,
    (bool, deleted)
    (bool, recent)
    (bool, seen)
    (boost::optional<std::int32_t>, thread_count)
    (boost::optional<std::int64_t>, new_count)
    (boost::optional<std::string>, in_reply_to)
    (std::int32_t, fid)
    (std::int64_t, imap_id)
    (std::int64_t, mid)
    (std::int64_t, size)
    (std::int64_t, revision)
    (boost::optional<std::int64_t>, tid)
    (std::string, extra_data)
    (std::string, firstline)
    (std::string, hdr_message_id)
    (std::string, st_id)
    (std::string, subject)
    (std::time_t, hdr_date)
    (std::time_t, received_date)
    (std::vector<std::int32_t>, lids)
    (std::vector<macs::pg::reflection::MessageAttach>, attaches)
    (std::vector<macs::pg::reflection::Recipient>, recipients)
    (std::vector<std::string>, attributes)
    (boost::optional<std::string>, tab)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), EnvelopeWithMime,
    (macs::pg::reflection::Envelope, envelope)
    (boost::optional<std::vector<macs::pg::reflection::MimePart>>, mime)
)

#endif // MACS_PG_REFLECTION_ENVELOPE_H
