#ifndef MACS_PG_REFLECTION_FOLDER_H
#define MACS_PG_REFLECTION_FOLDER_H

#include <cstdint>
#include <ctime>
#include <string>
#include <boost/optional.hpp>
#include <boost/fusion/adapted/struct/define_struct.hpp>

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), Pop3State,
    (bool, initialized)
    (bool, enabled)
)

BOOST_FUSION_DEFINE_STRUCT((macs)(pg)(reflection), Folder,
    (std::int32_t, fid)
    (boost::optional<std::int32_t>, parent_fid)
    (std::vector<std::string>, folder_path)
    (std::string, type)
    (std::time_t, created)
    (std::int64_t, message_size)
    (std::int64_t, message_count)
    (std::int64_t, message_seen)
    (std::int64_t, message_recent)
    (bool, unvisited)
    (std::size_t, position)
    (std::int64_t, revision)
    (std::int64_t, next_imap_id)
    (std::int64_t, uidvalidity)
    (std::int32_t, first_unseen)
    (macs::pg::reflection::Pop3State, pop3state)
    (bool, is_threadable)
    (boost::optional<bool>, subscribed_for_shared_folder)
)

#endif // MACS_PG_REFLECTION_FOLDER_H
