#ifndef MACS_PG_USER_JOURNAL_H
#define MACS_PG_USER_JOURNAL_H

#include <macs/user_journal.h>
#include <pgg/service/uid_resolver.h>

namespace macs {
namespace pg {

template <typename Resolver>
class UserJournal : public macs::UserJournal {
public:
    using Base = macs::UserJournal;

    UserJournal(Base::Journal journal,
            Resolver resolver, typename Resolver::element_type::Params resolveParams, logging::v2::LogPtr logger)
        : Base(std::move(journal)),
          resolver_(std::move(resolver)),
          resolveParams(std::move(resolveParams)),
          logger_(std::move(logger)) {}

private:
    const Resolver resolver_;
    typename Resolver::element_type::Params resolveParams;
    const logging::v2::LogPtr logger_;

    void asyncGetShardName(OnStringReceive handler) const override {
        const auto logger = logger_;
        resolver_->asyncGetShardName(resolveParams,
            [=] (error_code error, std::string name) {
                if (error) {
                    if (logger) {
                        using namespace logging;
                        logError(*logger, [&] {
                            Attributes attributes = { &error, OldMessage(error.message()) };
                            return Record{ "UserJournal::asyncGetShardName", "", std::move(attributes) };
                        });
                    }
                    handler("pg");
                } else {
                    handler(name);
                }
            });
    }
};

} // namespace pg
} // namespace macs

#endif // MACS_PG_USER_JOURNAL_H
