#ifndef MACS_PG_SHARED_FOLDERS_QUERY_H
#define MACS_PG_SHARED_FOLDERS_QUERY_H

#include <pgg/query/boundaries.h>
#include <internal/query/ids.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;

struct CreateSharedFolder : QueryImpl<CreateSharedFolder, UserId, pgg::RequestInfo, FolderId> {
    using Inherited::Inherited;
};

struct AddSubscriberToSharedFolder : QueryImpl<AddSubscriberToSharedFolder, UserId, pgg::RequestInfo, FolderId, Subscriber> {
    using Inherited::Inherited;
};

struct GetSharedFoldersByOwner : QueryImpl<GetSharedFoldersByOwner, UserId> {
    using Inherited::Inherited;
};

} // namespace query
} // namespace macs
} // namespace pg

#endif //MACS_PG_SHARED_FOLDERS_QUERY_H
