#pragma once

#include <macs_pg/shared_folders/repository.h>
#include <internal/shared_folders/query.h>
#include <pgg/database/database.h>
#include <pgg/query/repository.h>
#include <internal/query/comment.h>
#include <pgg/database/fallback.h>
#include <internal/hooks/wrap.h>

namespace macs {
namespace pg {

template <typename DatabaseGenerator>
class SharedFoldersRepository : public macs::SharedFoldersRepository {
public:
    typedef macs::SharedFoldersRepository Base;

    SharedFoldersRepository(const DatabaseGenerator& generator,
                      const std::string & uid, pgg::query::RepositoryPtr queryRepository,
                      const pgg::RequestInfo& requestInfo, pgg::Milliseconds transactionTimeout)
    : Base(), uid_(uid), queryRepository_(queryRepository), db(generator),
      requestInfo_(requestInfo), transactionTimeout_(transactionTimeout)
    {}
    virtual ~SharedFoldersRepository() = default;
private:
    template <typename T, typename ...ArgsT >
    T queryUpdate(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(queryRepository(), uid(),
                requestInfo_, std::forward<ArgsT>(args) ...);
    }

    virtual void asyncCreateSharedFolder(Fid fid, OnUpdate hook) const override;

    virtual void asyncAddSubscriber(Fid fid, const std::string& subscriberUid, OnUpdate hook) const override;

    virtual void asyncGetAllSharedFolders(OnFidVecReceive hook) const override;

    virtual void asyncCreateSharedFolderWithArchivation(Fid fid,
                                                        const Folder::ArchivationType &type,
                                                        uint32_t keep_days, uint32_t max_size,
                                                        OnUpdate hook) const override;

    const std::string & uid() const {
        return uid_;
    }
    const pgg::query::Repository & queryRepository() const {
        return *queryRepository_;
    }
    std::shared_ptr<const SharedFoldersRepository> getSelf() const {
        return std::dynamic_pointer_cast<const SharedFoldersRepository>(pgg::share(this));
    }

    const std::string uid_;
    pgg::query::RepositoryPtr queryRepository_;
    const DatabaseGenerator db;
    const pgg::RequestInfo requestInfo_;
    pgg::Milliseconds transactionTimeout_;
};

template <typename DatabaseGenerator>
SharedFoldersRepositoryPtr createSharedFoldersRepository(
    DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    pgg::Milliseconds timeout);

} //namespace pg
} //namespace macs

#include "repository.ipp"