#include <internal/shared_folders/repository.h>
#include <internal/shared_folders/create_shared_folder_with_archivation.h>
#include <internal/reflection/fid.h>

namespace macs {
namespace pg {

template <typename DatabaseGenerator>
void SharedFoldersRepository<DatabaseGenerator>::asyncCreateSharedFolder(Fid fid, OnUpdate hook) const {
    const auto q = queryUpdate<query::CreateSharedFolder>(query::FolderId(fid));
    db()->fetch(q, wrapHook(std::move(hook)));
}

template <typename DatabaseGenerator>
void SharedFoldersRepository<DatabaseGenerator>::asyncAddSubscriber(Fid fid, const std::string& subscriberUid, OnUpdate hook) const {
    const auto q = queryUpdate<query::AddSubscriberToSharedFolder>(query::FolderId(fid), query::Subscriber(subscriberUid));
    db()->fetch(q, wrapHook(std::move(hook)));
}

template <typename DatabaseGenerator>
void SharedFoldersRepository<DatabaseGenerator>::asyncGetAllSharedFolders(OnFidVecReceive hook) const {
    const auto q = queryRepository().template query<query::GetSharedFoldersByOwner>(query::UserId(uid()));
    db()->fetch(q, wrapHook<reflection::Fid>(std::move(hook), [](auto v){
        return std::to_string(v.fid);
    }));
}

template <typename DatabaseGenerator>
void SharedFoldersRepository<DatabaseGenerator>::asyncCreateSharedFolderWithArchivation(
        Fid fid, const Folder::ArchivationType &type,
        uint32_t keep_days, uint32_t max_size,
        OnUpdate hook) const {
    pgg::query::fallback::runTransactional(db, queryRepository_,
        CreateSharedFolderWithArchivation(queryRepository_,
                                          uid(), fid,
                                          type, keep_days, max_size,
                                          requestInfo_,
                                          transactionTimeout_,
                                          std::move(hook))
    );
}

} //namespace pg
} //namespace macs
