#pragma once

#include <macs_pg/logging.h>

#include <macs/stickers_repository.h>
#include <pgg/database/fallback.h>
#include <pgg/query/repository.h>
#include <pgg/request_info.h>
#include <internal/query/comment.h>
#include <internal/hooks/wrap.h>

#include <pgg/query/transactional.h>

namespace macs::pg {

template <typename DatabaseGenerator>
class StickersRepository : public macs::StickersRepository {
public:
    using Base = macs::StickersRepository;

    StickersRepository(macs::UserJournalPtr journal, const DatabaseGenerator& db, 
            std::string uid, pgg::query::RepositoryPtr queryRepository,
            logging::v2::LogPtr logger, pgg::RequestInfo requestInfo, pgg::Milliseconds transactionTimeout)
        : Base(std::move(journal))
        , db(db)
        , uid(std::move(uid))
        , queryRepository(std::move(queryRepository))
        , logger(std::move(logger))
        , requestInfo(std::move(requestInfo))
        , transactionTimeout(transactionTimeout)
    {}

    void asyncGetReplyLaterList(OnReplyLaterStickers) const override;
    void asyncCreateReplyLater(const Mid&, const Fid&, std::time_t date, const std::optional<Tab::Type>&, OnReplyLaterSticker) const override;
    void asyncRemoveReplyLater(const Mid& mid, OnUpdate) const override;
    void asyncRemoveIncorrectReplyLaterStickers(OnIncorrectStickersMids) const override;

private:
    template <typename T, typename ...ArgsT >
    T query(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(*queryRepository, uid,
                                       std::forward<ArgsT>(args) ...);
    }

    const DatabaseGenerator db;
    const std::string uid;
    const pgg::query::RepositoryPtr queryRepository;
    logging::v2::LogPtr logger;
    const pgg::RequestInfo requestInfo;
    const pgg::Milliseconds transactionTimeout;
};

template <typename DatabaseGenerator>
StickersRepositoryPtr createStickersRepository(
        macs::UserJournalPtr journal,
        const DatabaseGenerator& db,
        const std::string& uid,
        pgg::query::RepositoryPtr queryRepository,
        logging::v2::LogPtr logger,
        const pgg::RequestInfo& requestInfo,
        pgg::Milliseconds transactionTimeout
);

}

#include "repository.ipp"
