#include <internal/sticker/repository.h>
#include <internal/sticker/query.h>
#include <internal/hooks/wrap.h>
#include <internal/reflection/sticker.h>

namespace macs::pg {

inline auto fromReflection(reflection::ReplyLaterSticker& data) {
    return ReplyLaterSticker {
        .mid = std::to_string(data.mid),
        .type = macs::StickerType::reply_later,
        .created = data.created,
        .tid = std::to_string(data.tid),
        .fid = std::to_string(data.fid),
        .date = data.date,
        .tab = data.tab ? std::make_optional(Tab::Type::fromString(data.tab.get(), std::nothrow)) : std::nullopt,
    };
}

inline auto fromReflection(reflection::RemoveIncorrectReplyLaterStickersMids& data) {
    return std::move(data.mids);
}

template <typename DatabaseGenerator>
void StickersRepository<DatabaseGenerator>::asyncGetReplyLaterList(OnReplyLaterStickers hook) const {
    auto handler = wrapHook<reflection::ReplyLaterSticker>(
            std::move(hook),
            [] (reflection::ReplyLaterSticker data) {
                return fromReflection(data);
            }
    );

    db()->fetch(query<query::StickersReplyLaterList>(), std::move(handler));
}

template <typename DatabaseGenerator>
void StickersRepository<DatabaseGenerator>::asyncRemoveIncorrectReplyLaterStickers(OnIncorrectStickersMids hook) const {
    db()->fetch(
        query<query::RemoveIncorrectReplyLaterStickers>(),
        wrapHook<reflection::RemoveIncorrectReplyLaterStickersMids>(
            std::move(hook),
            [] (reflection::RemoveIncorrectReplyLaterStickersMids data) {
                return fromReflection(data);
            }
        )
    );
}

template <typename DatabaseGenerator>
void StickersRepository<DatabaseGenerator>::asyncCreateReplyLater(const Mid& mid, const Fid& fid, std::time_t date,
        const std::optional<Tab::Type>& tab, OnReplyLaterSticker hook) const {
    auto handler = wrapHook<reflection::ReplyLaterSticker>(
            std::move(hook),
            [] (reflection::ReplyLaterSticker data) {
                return fromReflection(data);
            }
    );

    db()->fetch(query<query::CreateReplyLaterSticker>(query::MailId(mid), query::FolderId(fid), query::Date(date),
            requestInfo, query::OptTabType(tab)), std::move(handler));
}

template <typename DatabaseGenerator>
void StickersRepository<DatabaseGenerator>::asyncRemoveReplyLater(const Mid& mid, OnUpdate honk) const {
    db()->fetch(query<query::RemoveReplyLaterSticker>(query::MailId(mid), requestInfo), wrapHook(std::move(honk)));
}

}
