#ifndef MACS_PG_SUBSCRIBED_FOLDERS_QUERY_H
#define MACS_PG_SUBSCRIBED_FOLDERS_QUERY_H

#include <pgg/query/boundaries.h>
#include <internal/query/ids.h>
#include <internal/envelope/envelope.h>
#include <internal/query/threads_meta.h>
#include <internal/envelope/mime_parts.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;
using pgg::RequestInfo;

struct SubscribedFoldersAddFolder: QueryImpl<
        SubscribedFoldersAddFolder, UserId, RequestInfo, FolderId, OwnerUserId, OwnerFolderId>{
    using Inherited::Inherited;
};

struct SubscribedFoldersGetFolder: QueryImpl<
        SubscribedFoldersGetFolder, UserId, OwnerUserId, OwnerFolderId>{
    using Inherited::Inherited;
};

struct SubscribedFoldersRemoveFolders: QueryImpl<
        SubscribedFoldersRemoveFolders, UserId, OwnerUserId, FolderIdVector, RequestInfo>{
    using Inherited::Inherited;
};

struct SubscribedFoldersDeleteMessages: QueryImpl<
        SubscribedFoldersDeleteMessages, UserId, OwnerUserId, OwnerFolderId, OwnerMids,
        OwnerRevision, RequestInfo>{
    using Inherited::Inherited;
};

struct SubscribedFoldersAddLabels : QueryImpl<
        SubscribedFoldersAddLabels, UserId, OwnerUserId, OwnerFolderId, OwnerMids,
        OwnerRevision, SetSeen, SetRecent, SetDeleted, LabelIdList, RequestInfo> {
    using Inherited::Inherited;
};

struct SubscribedFoldersRemoveLabels : QueryImpl<
    SubscribedFoldersRemoveLabels, UserId, OwnerUserId, OwnerFolderId, OwnerMids,
    OwnerRevision, SetSeen, SetRecent, SetDeleted, LabelIdList, RequestInfo> {
    using Inherited::Inherited;
};

struct SubscribedFoldersGetSyncedRevision : QueryImpl<
        SubscribedFoldersGetSyncedRevision, UserId, OwnerUserId, OwnerFolderId> {
    using Inherited::Inherited;
};

struct SubscribedFoldersSyncMessage : QueryImpl<
        SubscribedFoldersSyncMessage, UserId, OwnerUserId, OwnerRevision, macs::Envelope,
        MimeParts, ReferenceHashes, InReplyToHash, QuietFlag, RequestInfo, imap_id> {
    using Inherited::Inherited;
};

struct SubscribedFoldersSyncJoinThreads: QueryImpl<
        SubscribedFoldersSyncJoinThreads, UserId, OwnerUserId, OwnerFolderId,
        OwnerThreadId, OwnerJoinThreadIds, OwnerRevision, RequestInfo> {
    using Inherited::Inherited;
};

struct SubscribedFoldersGetEnvelopes : QueryImpl<
        SubscribedFoldersGetEnvelopes, UserId, OwnerUserId, OwnerFolderId> {
    using Inherited::Inherited;
};

struct SubscribedFoldersGetFoldersByOwner : QueryImpl<
        SubscribedFoldersGetFoldersByOwner, UserId, OwnerUserId> {
    using Inherited::Inherited;
};

struct SubscribedFoldersGetSyncedMids : QueryImpl<
        SubscribedFoldersGetSyncedMids, UserId, OwnerUserId, OwnerFolderId, RowCount> {
    using Inherited::Inherited;
};

struct SubscribedFoldersGetLastSyncedImapId : QueryImpl<
        SubscribedFoldersGetLastSyncedImapId, UserId, OwnerUserId, OwnerFolderId> {
    using Inherited::Inherited;
};

} // namespace query
} // namespace pg
} // namespace macs

#endif //MACS_PG_SUBSCRIBED_FOLDERS_QUERY_H
