#pragma once

#include <macs_pg/subscribed_folders/repository.h>

#include <pgg/database/database.h>
#include <pgg/query/repository.h>
#include <internal/query/comment.h>
#include <pgg/database/fallback.h>
#include <internal/hooks/wrap.h>
#include <internal/label/repository.h>

namespace macs {
namespace pg {

template <typename DatabaseGenerator>
class SubscribedFoldersRepository : public macs::SubscribedFoldersRepository {
public:
    typedef macs::SubscribedFoldersRepository Base;

    SubscribedFoldersRepository(const DatabaseGenerator& generator,
                                const std::string & uid,
                                LabelsRepositoryPtr labelsRepository,
                                pgg::query::RepositoryPtr queryRepository,
                                const pgg::RequestInfo& requestInfo)
            : Base(), uid_(uid), labelsRepository_(labelsRepository),
              queryRepository_(queryRepository), db(std::move(generator)),
              requestInfo_(requestInfo)
    {}

    virtual ~SubscribedFoldersRepository() = default;

private:
    void asyncAddFolder(Fid fid,
                        std::string ownerUid,
                        Fid ownerFid,
                        OnSubscribedFolder hook) const override;

    void asyncGetFolder(std::string ownerUid,
                        Fid ownerFid,
                        OnSubscribedFolder hook) const override;

    void asyncRemoveFolders(std::string ownerUid,
                            std::vector<Fid> ownerFids,
                            OnFidVecReceive hook) const override;

    void asyncDeleteMessages(std::string ownerUid,
                             Fid ownerFid,
                             MidVec ownerMids,
                             Revision ownerRevision,
                             OnUpdateMessages hook) const override;

    void asyncAddLabels(const std::string& ownerUid,
                        const Fid& ownerFid,
                        const MidVec& ownerMids,
                        const Revision& ownerRevision,
                        const std::vector<Label>& labels,
                        OnUpdateMessages hook) const override;

    void asyncRemoveLabels(const std::string& ownerUid,
                           const Fid& ownerFid,
                           const MidVec& ownerMids,
                           const Revision& ownerRevision,
                           const std::vector<Label>& labels,
                           OnUpdateMessages hook) const override;

    void asyncGetSyncedRevision(const std::string& ownerId,
                                const Fid& ownerFid,
                                OnOptRevisionReceive hook) const override;

    void asyncSyncMessage(const std::string& ownerUid,
                          const Envelope& envelope,
                          const MimeParts& mime,
                          const std::vector<Hash>& referenceHashes,
                          const Hash& inReplyToHash,
                          NotificationMode notificationMode,
                          OnSyncMessage hook) const override;

    void asyncJoinThreads(const std::string& ownerUid,
                          const Fid& ownerFid,
                          const ThreadId& ownerTid,
                          const std::vector<ThreadId>& ownerJoinTids,
                          const Revision& ownerRevision,
                          OnUpdateMessages hook) const override;

    void asyncGetEnvelopes(const std::string& ownerUid,
                           const Fid& ownerFid,
                           OnEnvelopeReceive hook) const override;

    void asyncGetFoldersByOwner(const std::string &ownerUid,
                                OnSubscribedFolders hook) const override;

    void asyncGetSyncedMids(const std::string &ownerUid,
                            const Fid &ownerFid,
                            std::size_t rowCount,
                            OnMidsReceive hook) const override;

    void asyncGetLastSyncedImapId(const std::string& ownerUid,
                                    const Fid& ownerFid,
                                    Hook<int64_t> hook) const override;

    const std::string & uid() const {
        return uid_;
    }

    const pgg::query::Repository& queryRepository() const {
        return *queryRepository_;
    }

    macs::LabelsRepository& labels() const {
        return *labelsRepository_;
    }

    const std::string uid_;
    LabelsRepositoryPtr labelsRepository_;
    pgg::query::RepositoryPtr queryRepository_;
    const DatabaseGenerator db;
    const pgg::RequestInfo requestInfo_;
};

template <typename DatabaseGenerator>
SubscribedFoldersRepositoryPtr createSubscribedFoldersRepository(
    DatabaseGenerator dbg,
    const std::string& uid,
    LabelsRepositoryPtr labelsRepositiory,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo);

} // namespace pg
} // namespace macs

#include "repository.ipp"
