#ifndef MACS_PG_SUBSCRIPTION_QUERY_H_17032017
#define MACS_PG_SUBSCRIPTION_QUERY_H_17032017

#include <pgg/query/boundaries.h>
#include <internal/query/ids.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;
using pgg::RequestInfo;

struct FindAJob: QueryImpl<FindAJob, AliveTimeoutSeconds, LaunchId, Hostname, WorkerVersion>{
    using Inherited::Inherited;
};

struct ConfirmTheJob: QueryImpl<ConfirmTheJob, WorkerId, LaunchId>{
    using Inherited::Inherited;
};

struct SubscriptionsByWorkerId: QueryImpl<SubscriptionsByWorkerId, WorkerId>{
    using Inherited::Inherited;
};

struct SubscriptionById: QueryImpl<SubscriptionById, UserId, SubscriptionId>{
    using Inherited::Inherited;
};

struct TransitSubscriptionState: QueryImpl<TransitSubscriptionState, UserId, SubscriptionId, SubscriptionAction>{
    using Inherited::Inherited;
};

struct MarkSubscriptionFailed: QueryImpl<MarkSubscriptionFailed, UserId, SubscriptionId, FailReason>{
    using Inherited::Inherited;
};

struct GetFreeSubscriptions: QueryImpl<GetFreeSubscriptions, WorkerId, SubscriptionsLimit>{
    using Inherited::Inherited;
};

struct ReleaseSubscription: QueryImpl<ReleaseSubscription, UserId, SubscriptionId, WorkerId> {
    using Inherited::Inherited;
};

struct SubscriptionsBySubscriberAndFids: QueryImpl<SubscriptionsBySubscriberAndFids, UserId, Subscriber, FolderIdVector>{
    using Inherited::Inherited;
};

struct RemoveSubscriptionsChunk: QueryImpl<RemoveSubscriptionsChunk, UserId, SubscriptionIdVec, RequestInfo>{
    using Inherited::Inherited;
};

struct AddUnsubscribeTask: QueryImpl<AddUnsubscribeTask, TaskRequestId, OwnerUserId, OwnerFolderIds, UserId, FolderId>{
    using Inherited::Inherited;
};

struct GetUnsubscribeTasks: QueryImpl<GetUnsubscribeTasks, SubscriptionsLimit, AliveTimeoutSeconds>{
    using Inherited::Inherited;
};

struct RemoveSubscriptionsAndTask: QueryImpl<RemoveSubscriptionsAndTask, TaskId, RequestInfo>{
    using Inherited::Inherited;
};

} // namespace query
} // namespace pg
} // namespace macs

#endif /* MACS_PG_SUBSCRIPTION_QUERY_H_17032017 */
