#pragma once

#include <boost/algorithm/string/join.hpp>

#include <macs/tab_factory.h>
#include <pgg/numeric_cast.h>
#include <internal/reflection/tab.h>

namespace macs {
namespace pg {

class TabFactory: public macs::TabFactory {
public:

    TabFactory &seenMessages(const size_t & messageSeen) {
        newMessagesCount(product().messagesCount() - messageSeen);
        return *this;
    }

    TabFactory &fromReflection(const reflection::Tab& v) {
        reset();

        type(Tab::Type::fromString(v.tab, std::nothrow));
        bytes(PGG_NUMERIC_CAST(std::size_t, v.message_size));
        messagesCount(PGG_NUMERIC_CAST(std::size_t, v.message_count));
        seenMessages(PGG_NUMERIC_CAST(std::size_t, v.message_seen));
        freshMessagesCount(PGG_NUMERIC_CAST(std::size_t, v.fresh_count));

        creationTime(v.created);
        revision(PGG_NUMERIC_CAST(Revision, v.revision));
        return *this;
    }
};

} // namespace macs
} // namespace pg
