#pragma once

#include <pgg/query/boundaries.h>
#include <internal/query/ids.h>
#include <macs/tab.h>

namespace macs {
namespace pg {
namespace query {

using pgg::query::QueryImpl;

struct AllTabsList : QueryImpl<AllTabsList, UserId> {
    using Inherited::Inherited;
};

struct GetOrCreateTab : QueryImpl<GetOrCreateTab, UserId, pgg::RequestInfo, TabType> {
    using Inherited::Inherited;
};

struct ResetTabFresh : QueryImpl<ResetTabFresh, UserId, pgg::RequestInfo, TabType> {
    using Inherited::Inherited;
};

struct CanReadTabs : QueryImpl<CanReadTabs, UserId> {
    using Inherited::Inherited;
};

} // namespace query
} // namespace macs
} // namespace pg
