#pragma once

#include <internal/envelope/envelope.h>
#include <internal/envelope/factory.h>
#include <macs/types.h>

namespace macs {
namespace pg {

struct JoinThreadResult {
    ThreadId tid;
    std::vector<Lid> addLids;
    std::vector<Lid> removeLids;
};

inline void applyJoinThreadResult(macs::EnvelopeFactory& factory, const JoinThreadResult& res) {
    factory.threadId(res.tid);
    factory.addLabelIDs(res.addLids);
    for (const auto& lid: res.removeLids) {
        factory.removeLabel(lid);
    }
}

} // namespace pg
} // namespace macs
