#ifndef MACS_PG_THREAD_QUERY_H
#define MACS_PG_THREAD_QUERY_H

#include <pgg/query/boundaries.h>
#include <pgg/query/ranges.h>
#include <internal/query/ids.h>
#include <internal/query/threads_meta.h>

namespace macs {
namespace pg {

using pgg::query::QueryImpl;

struct ParticipantsList : QueryImpl<ParticipantsList,
    query::UserId, query::ThreadIdVector > {
    using Inherited::Inherited;
};

struct ThreadLabels : QueryImpl<ThreadLabels,
    query::UserId, query::ThreadIdVector > {
    using Inherited::Inherited;
};

struct MailsInThreads : QueryImpl<MailsInThreads,
    query::UserId, query::ThreadIdList, query::MailIdList, query::LabelIdToCheckList > {
    using Inherited::Inherited;
};

struct MidsInFolder : QueryImpl<MidsInFolder,
    query::UserId, query::ThreadIdList, query::FolderId > {
    using Inherited::Inherited;
};

struct MidsInThreadsWithSeen : QueryImpl<MidsInThreadsWithSeen,
    query::UserId, query::ThreadIdList, query::MailIdList, query::Seen > {
    using Inherited::Inherited;
};

struct MidsInThreadsWithoutLabel : QueryImpl<MidsInThreadsWithoutLabel,
    query::UserId, query::ThreadIdList, query::MailIdList, query::LabelId > {
    using Inherited::Inherited;
};

struct FindThreadsByHash : QueryImpl<FindThreadsByHash,
    query::UserId, ThreadLimits, ThreadHash> {
    using Inherited::Inherited;
};

struct FindThreadsByReferences : QueryImpl<FindThreadsByReferences,
    query::UserId, query::MailIdVec, query::MailRefVec> {
    using Inherited::Inherited;
};

struct JoinThreads : QueryImpl<JoinThreads, query::UserId,
    query::ThreadId, query::ThreadIdVector> {
    using Inherited::Inherited;
};

struct MessageCountInThreads : QueryImpl<MessageCountInThreads, query::UserId,
        query::ThreadIdVector> {
    using Inherited::Inherited;
};

} // namespace pg
} // namespace macs

#endif // MACS_PG_THREAD_QUERY_H

