#ifndef MACS_PG_THREAD_STRUCTURES_PARTICIPANT_GROUPER_H
#define MACS_PG_THREAD_STRUCTURES_PARTICIPANT_GROUPER_H

#include <internal/reflection/participant_with_tid.h>
#include <macs/thread_participants_factory.h>
#include <boost/range/algorithm.hpp>
#include <macs/thread_participants.h>
#include <butil/email/helpers.h>
#include <boost/range.hpp>

namespace macs {
namespace pg {

class ParticipantGrouper {
    using ParticipantWithTid = reflection::ParticipantWithTid;
    using MessageType = macs::ThreadParticipants::Participant::MessageType;
    using Data = std::vector<ParticipantWithTid>;
    using Result = ThreadParticipantsList;

    ThreadParticipants::Participant createParticipant(const ParticipantWithTid& sp, const Email& from) const {
        ThreadParticipants::Participant ret(std::to_string(sp.mid), from);
        for(const auto& lid : sp.lids) {
            ret.addType(lid);
        }
        return ret;
    }

    template <typename Range>
    ThreadParticipants createThreadParticipants( int64_t tid,  Range range ) const {
        auto factory = ThreadParticipantsFactory().threadId(std::to_string(tid));
        for (const auto& i : range) {
            auto email = EmailHelpers::fromString(i.from);
            if (!factory.existParticipant(email)) {
                factory.addParticipant(createParticipant(i, email));
            }
        }
        return std::move(factory.product());
    }

    template <typename Iter, typename Pred>
    auto next(Iter f, Iter l, Pred p) const {
        using namespace boost;
        return adjacent_find<return_begin_next>(make_iterator_range(f, l), p);
    }

public:

    Result groupByTid(Data& data) const {
        using namespace boost;
        using Cref = const ParticipantWithTid&;

        auto less = [](Cref a1, Cref a2) { return a1.tid < a2.tid; };
        stable_sort(data, less);

        Result res;
        auto range = next(data.begin(), data.end(), less);
        for(; !range.empty(); range = next(range.end(), data.end(), less)) {
            res.push_back(createThreadParticipants(range.begin()->tid, range));
        }

        return res;
      }
};

}
}

#endif // MACS_PG_THREAD_STRUCTURES_PARTICIPANT_GROUPER_H

