#pragma once

#include <internal/query/ids.h>

#include <pgg/query/boundaries.h>

namespace macs::pg::query {

struct FreezingInfo : pgg::query::QueryImpl<FreezingInfo, UserId> {
    using Inherited::Inherited;
};

struct ChangeUserState : pgg::query::QueryImpl<ChangeUserState, UserId, pgg::RequestInfo, FromUserState, ToUserState> {
    using Inherited::Inherited;
};

struct GetArchive : pgg::query::QueryImpl<GetArchive, UserId> {
    using Inherited::Inherited;
};

struct ActivateUserAndUpdateArchiveState : 
        pgg::query::QueryImpl<ActivateUserAndUpdateArchiveState, UserId, pgg::RequestInfo, FromArchiveState, ToArchiveState> {
    using Inherited::Inherited;
};

struct ExchangeArchiveTaskId : pgg::query::QueryImpl<ExchangeArchiveTaskId, UserId, FromTaskId, ToTaskId> {
    using Inherited::Inherited;
};

struct ExchangeArchiveState : pgg::query::QueryImpl<ExchangeArchiveState, UserId, FromUserState, FromArchiveState, ToArchiveState, OptionalNotice> {
    using Inherited::Inherited;
};

struct UpdateRestorationProgress : pgg::query::QueryImpl<UpdateRestorationProgress, UserId, TaskId, RestoredMessageCount> {
    using Inherited::Inherited;
};

}
