#pragma once

#include <macs_pg/logging.h>

#include <macs/users_repository.h>
#include <pgg/query/repository.h>
#include <pgg/request_info.h>
#include <internal/query/comment.h>

namespace macs::pg {

template <typename DatabaseGenerator>
class UsersRepository : public macs::UsersRepository {
public:
    UsersRepository(const DatabaseGenerator& db, std::string uid, pgg::query::RepositoryPtr queryRepository,
                       logging::v2::LogPtr logger, pgg::RequestInfo requestInfo)
    : db(db)
    , uid_(std::move(uid))
    , queryRepository_(std::move(queryRepository))
    , logger_(std::move(logger))
    , requestInfo_(std::move(requestInfo))
    {}

    void asyncFreezingInfo(OnFreezingInfo handler) const override;
    void asyncChangeUserState(macs::UserState fromState, macs::UserState toState, OnExecute handler) const override;
    void asyncGetArchive(onArchive handler) const override;
    void asyncActivateUserAndUpdateArchiveState(macs::ArchiveState fromState, macs::ArchiveState toState, OnExecute handler) const override;
    void asyncExchangeArchiveTaskId(macs::TaskId from, macs::TaskId to, OnExecute handler) const override;
    void asyncExchangeArchiveState(macs::UserState userState, macs::ArchiveState from, macs::ArchiveState to,
                                        std::optional<std::string> notice, OnExecute handler) const override;
    
    virtual void asyncUpdateRestorationProgress(macs::TaskId fromTaskId, std::int32_t restoredMessageCount, OnExecute handler) const override;

private:
    template <typename T, typename ...ArgsT >
    T query(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(*queryRepository_, uid_, std::forward<ArgsT>(args) ...);
    }

    template <typename T, typename ...ArgsT >
    T queryUpdate(ArgsT&& ... args) const {
        return makeQueryWithComment<T>(*queryRepository_, uid_, requestInfo_, std::forward<ArgsT>(args) ...);
    }

    const DatabaseGenerator db;
    const std::string uid_;
    const pgg::query::RepositoryPtr queryRepository_;
    logging::v2::LogPtr logger_;
    const pgg::RequestInfo requestInfo_;
};

template <typename DatabaseGenerator>
UsersRepositoryPtr createUsersRepository(
    const DatabaseGenerator& db,
    const std::string& uid,
    pgg::query::RepositoryPtr queryRepository,
    logging::v2::LogPtr logger,
    const pgg::RequestInfo& requestInfo);

}

#include "repository.ipp"
