#pragma once

#include <macs/archive.h>
#include <macs/freezing_info.h>
#include <pgg/enumeration.h>

#include <boost/assign.hpp>

namespace macs::pg {

struct UserStateImpl {
    using Enum = macs::UserState;
    using Filler = UserStateImpl;
    using Map = pgg::Enum2String<Enum>::Map;

    // clang-format off
    void fill(Map& map) {
        boost::assign::insert(map)
            ( Enum::active,   "active" )
            ( Enum::inactive, "inactive" )
            ( Enum::notified, "notified" )
            ( Enum::frozen,   "frozen" )
            ( Enum::archived, "archived" )
            ( Enum::deleted,  "deleted" )
            ( Enum::special,  "special" );
    }
    // clang-format on
};

using UserState = pgg::Enumeration<UserStateImpl, UserStateImpl::Enum::active>;

struct ArchiveStateImpl {
    using Enum = macs::ArchiveState;
    using Filler = ArchiveStateImpl;
    using Map = pgg::Enum2String<Enum>::Map;

    // clang-format off
    void fill(Map& map) {
        boost::assign::insert(map)
            ( Enum::archivation_in_progress,   "archivation_in_progress" )
            ( Enum::archivation_complete, "archivation_complete" )
            ( Enum::archivation_error, "archivation_error" )
            ( Enum::restoration_in_progress, "restoration_in_progress" )
            ( Enum::restoration_complete,  "restoration_complete" )
            ( Enum::restoration_error,  "restoration_error" )
            ( Enum::restoration_requested,  "restoration_requested" )
            ( Enum::cleaning_requested,   "cleaning_requested" )
            ( Enum::cleaning_in_progress, "cleaning_in_progress" )
            ;
    }
    // clang-format on
};

using ArchiveState = pgg::Enumeration<ArchiveStateImpl, ArchiveStateImpl::Enum::archivation_in_progress>;

}  // namespace macs::pg
