#ifndef MACS_CHANGE_FACTORY_H
#define MACS_CHANGE_FACTORY_H

#include <macs_pg/changelog/change.h>

namespace macs {

class ChangeFactory: private ChangeDataInterface<ChangeFactory> {
public:

#define MODIFIER(NAME) \
    ChangeFactory & NAME (const decltype(ChangeData::NAME) & v) { \
        data().NAME = std::move(v); \
        return *this; \
    }

    MODIFIER(changeId)
    MODIFIER(uid)
    MODIFIER(type)
    MODIFIER(revision)
    MODIFIER(changed)
    MODIFIER(arguments)

#undef MODIFIER
    ChangeFactory() = default;
    ChangeFactory(const Change& src)
    : data_(std::make_shared<ChangeData>(src.data())) {
    }

    ChangeFactory& reset() {
        data_.reset();
        return *this;
    }

    Change release() {
        auto retval = std::move(data_);
        reset();
        return Change(std::move(retval));
    }

    ChangeFactory(const ChangeFactory& ) = delete;
    ChangeFactory(ChangeFactory&&) = default;
    ChangeFactory& operator=(const ChangeFactory&) = delete;
    ChangeFactory& operator=(ChangeFactory&&) = default;
private:
    friend class ChangeDataInterface<ChangeFactory>;

    ChangeData& data() {
        if(!data_) {
            data_ = std::make_shared<ChangeData>();
        }
        return *data_;
    }
    const ChangeData& data() const {
        return data_ ? *data_ : ChangeData::default_;
    }

    std::shared_ptr<ChangeData> data_;
};

} // namespace macs

#undef MODIFIER

#endif  /* MACS_CHANGE_FACTORY_H */
