#ifndef MACS_PG_CHANGELOG_TYPES_H_19122017
#define MACS_PG_CHANGELOG_TYPES_H_19122017

#include <macs_pg/subscription/types.h>
#include <string>

namespace macs {

using ChangeId = int64_t;

struct ChangeReference {
    ChangeId change = 0;
    std::string uid;
    SubscriptionId subscriptionId = 0;
    ChangeReference() = default;
    ChangeReference(ChangeId cid, std::string uid, SubscriptionId sid)
    : change(cid), uid(std::move(uid)), subscriptionId(sid) {}
};

} // namespace macs

#endif /* MACS_PG_CHANGELOG_TYPES_H_19122017 */
